# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.app import App
from ..types.get_app_response import GetAppResponse
from .raw_client import AsyncRawAppsClient, RawAppsClient
from .types.apps_list_request_sort_direction import AppsListRequestSortDirection
from .types.apps_list_request_sort_key import AppsListRequestSortKey


class AppsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAppsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAppsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAppsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        after: typing.Optional[str] = None,
        before: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        q: typing.Optional[str] = None,
        sort_key: typing.Optional[AppsListRequestSortKey] = None,
        sort_direction: typing.Optional[AppsListRequestSortDirection] = None,
        category_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[App]:
        """
        Parameters
        ----------
        after : typing.Optional[str]
            The cursor to start from for pagination

        before : typing.Optional[str]
            The cursor to end before for pagination

        limit : typing.Optional[int]
            The maximum number of results to return

        q : typing.Optional[str]
            A search query to filter the apps

        sort_key : typing.Optional[AppsListRequestSortKey]
            The key to sort the apps by

        sort_direction : typing.Optional[AppsListRequestSortDirection]
            The direction to sort the apps

        category_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Only return apps in these categories

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[App]
            apps listed

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        response = client.apps.list()
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            after=after,
            before=before,
            limit=limit,
            q=q,
            sort_key=sort_key,
            sort_direction=sort_direction,
            category_ids=category_ids,
            request_options=request_options,
        )

    def retrieve(self, app_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetAppResponse:
        """
        Parameters
        ----------
        app_id : str
            The name slug or ID of the app (e.g., 'slack', 'github')

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetAppResponse
            app retrieved

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.apps.retrieve(
            app_id="app_id",
        )
        """
        _response = self._raw_client.retrieve(app_id, request_options=request_options)
        return _response.data


class AsyncAppsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAppsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAppsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAppsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        after: typing.Optional[str] = None,
        before: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        q: typing.Optional[str] = None,
        sort_key: typing.Optional[AppsListRequestSortKey] = None,
        sort_direction: typing.Optional[AppsListRequestSortDirection] = None,
        category_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[App]:
        """
        Parameters
        ----------
        after : typing.Optional[str]
            The cursor to start from for pagination

        before : typing.Optional[str]
            The cursor to end before for pagination

        limit : typing.Optional[int]
            The maximum number of results to return

        q : typing.Optional[str]
            A search query to filter the apps

        sort_key : typing.Optional[AppsListRequestSortKey]
            The key to sort the apps by

        sort_direction : typing.Optional[AppsListRequestSortDirection]
            The direction to sort the apps

        category_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Only return apps in these categories

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[App]
            apps listed

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            response = await client.apps.list()
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            after=after,
            before=before,
            limit=limit,
            q=q,
            sort_key=sort_key,
            sort_direction=sort_direction,
            category_ids=category_ids,
            request_options=request_options,
        )

    async def retrieve(self, app_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetAppResponse:
        """
        Parameters
        ----------
        app_id : str
            The name slug or ID of the app (e.g., 'slack', 'github')

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetAppResponse
            app retrieved

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.apps.retrieve(
                app_id="app_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(app_id, request_options=request_options)
        return _response.data
