# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pagination import AsyncPager, BaseHttpResponse, SyncPager
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..types.deployed_component import DeployedComponent
from ..types.emitted_event import EmittedEvent
from ..types.get_trigger_events_response import GetTriggerEventsResponse
from ..types.get_trigger_response import GetTriggerResponse
from ..types.get_trigger_webhooks_response import GetTriggerWebhooksResponse
from ..types.get_trigger_workflows_response import GetTriggerWorkflowsResponse
from ..types.get_triggers_response import GetTriggersResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawDeployedTriggersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        external_user_id: str,
        after: typing.Optional[str] = None,
        before: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[DeployedComponent]:
        """
        Parameters
        ----------
        external_user_id : str
            Your end user ID, for whom you deployed the trigger

        after : typing.Optional[str]
            The cursor to start from for pagination

        before : typing.Optional[str]
            The cursor to end before for pagination

        limit : typing.Optional[int]
            The maximum number of results to return

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[DeployedComponent]
            deployed triggers listed
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/deployed-triggers",
            method="GET",
            params={
                "after": after,
                "before": before,
                "limit": limit,
                "external_user_id": external_user_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    GetTriggersResponse,
                    parse_obj_as(
                        type_=GetTriggersResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.data
                _has_next = False
                _get_next = None
                if _parsed_response.page_info is not None:
                    _parsed_next = _parsed_response.page_info.end_cursor
                    _has_next = _parsed_next is not None and _parsed_next != ""
                    _get_next = lambda: self.list(
                        external_user_id=external_user_id,
                        after=_parsed_next,
                        before=before,
                        limit=limit,
                        request_options=request_options,
                    )
                return SyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def retrieve(
        self, trigger_id: str, *, external_user_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[DeployedComponent]:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            Your end user ID, for whom you deployed the trigger

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DeployedComponent]
            deployed trigger retrieved
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/deployed-triggers/{jsonable_encoder(trigger_id)}",
            method="GET",
            params={
                "external_user_id": external_user_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    GetTriggerResponse,
                    parse_obj_as(
                        type_=GetTriggerResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _data = _parsed_response.data
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        trigger_id: str,
        *,
        external_user_id: str,
        active: typing.Optional[bool] = OMIT,
        configured_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DeployedComponent]:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        active : typing.Optional[bool]
            Whether the trigger should be active

        configured_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The configured properties for the trigger

        name : typing.Optional[str]
            The name of the trigger

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DeployedComponent]
            deployed trigger updated
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/deployed-triggers/{jsonable_encoder(trigger_id)}",
            method="PUT",
            params={
                "external_user_id": external_user_id,
            },
            json={
                "active": active,
                "configured_props": configured_props,
                "name": name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    GetTriggerResponse,
                    parse_obj_as(
                        type_=GetTriggerResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _data = _parsed_response.data
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(
        self,
        trigger_id: str,
        *,
        external_user_id: str,
        ignore_hook_errors: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[None]:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        ignore_hook_errors : typing.Optional[bool]
            Whether to ignore errors during deactivation hook

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/deployed-triggers/{jsonable_encoder(trigger_id)}",
            method="DELETE",
            params={
                "external_user_id": external_user_id,
                "ignore_hook_errors": ignore_hook_errors,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list_events(
        self,
        trigger_id: str,
        *,
        external_user_id: str,
        n: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[EmittedEvent]]:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            Your end user ID, for whom you deployed the trigger

        n : typing.Optional[int]
            The number of events to retrieve (defaults to 20 if not provided)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[EmittedEvent]]
            trigger events retrieved
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/deployed-triggers/{jsonable_encoder(trigger_id)}/events",
            method="GET",
            params={
                "external_user_id": external_user_id,
                "n": n,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    GetTriggerEventsResponse,
                    parse_obj_as(
                        type_=GetTriggerEventsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _data = _parsed_response.data
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list_workflows(
        self, trigger_id: str, *, external_user_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetTriggerWorkflowsResponse]:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetTriggerWorkflowsResponse]
            trigger workflows retrieved
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/deployed-triggers/{jsonable_encoder(trigger_id)}/pipelines",
            method="GET",
            params={
                "external_user_id": external_user_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetTriggerWorkflowsResponse,
                    parse_obj_as(
                        type_=GetTriggerWorkflowsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_workflows(
        self,
        trigger_id: str,
        *,
        external_user_id: str,
        workflow_ids: typing.Sequence[str],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetTriggerWorkflowsResponse]:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        workflow_ids : typing.Sequence[str]
            Array of workflow IDs to set

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetTriggerWorkflowsResponse]
            trigger workflows updated
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/deployed-triggers/{jsonable_encoder(trigger_id)}/pipelines",
            method="PUT",
            params={
                "external_user_id": external_user_id,
            },
            json={
                "workflow_ids": workflow_ids,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetTriggerWorkflowsResponse,
                    parse_obj_as(
                        type_=GetTriggerWorkflowsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list_webhooks(
        self, trigger_id: str, *, external_user_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetTriggerWebhooksResponse]:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetTriggerWebhooksResponse]
            trigger webhooks retrieved
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/deployed-triggers/{jsonable_encoder(trigger_id)}/webhooks",
            method="GET",
            params={
                "external_user_id": external_user_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetTriggerWebhooksResponse,
                    parse_obj_as(
                        type_=GetTriggerWebhooksResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_webhooks(
        self,
        trigger_id: str,
        *,
        external_user_id: str,
        webhook_urls: typing.Sequence[str],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetTriggerWebhooksResponse]:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        webhook_urls : typing.Sequence[str]
            Array of webhook URLs to set

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetTriggerWebhooksResponse]
            trigger webhooks updated
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/deployed-triggers/{jsonable_encoder(trigger_id)}/webhooks",
            method="PUT",
            params={
                "external_user_id": external_user_id,
            },
            json={
                "webhook_urls": webhook_urls,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetTriggerWebhooksResponse,
                    parse_obj_as(
                        type_=GetTriggerWebhooksResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawDeployedTriggersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        external_user_id: str,
        after: typing.Optional[str] = None,
        before: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[DeployedComponent]:
        """
        Parameters
        ----------
        external_user_id : str
            Your end user ID, for whom you deployed the trigger

        after : typing.Optional[str]
            The cursor to start from for pagination

        before : typing.Optional[str]
            The cursor to end before for pagination

        limit : typing.Optional[int]
            The maximum number of results to return

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[DeployedComponent]
            deployed triggers listed
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/deployed-triggers",
            method="GET",
            params={
                "after": after,
                "before": before,
                "limit": limit,
                "external_user_id": external_user_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    GetTriggersResponse,
                    parse_obj_as(
                        type_=GetTriggersResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.data
                _has_next = False
                _get_next = None
                if _parsed_response.page_info is not None:
                    _parsed_next = _parsed_response.page_info.end_cursor
                    _has_next = _parsed_next is not None and _parsed_next != ""

                    async def _get_next():
                        return await self.list(
                            external_user_id=external_user_id,
                            after=_parsed_next,
                            before=before,
                            limit=limit,
                            request_options=request_options,
                        )

                return AsyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def retrieve(
        self, trigger_id: str, *, external_user_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[DeployedComponent]:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            Your end user ID, for whom you deployed the trigger

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DeployedComponent]
            deployed trigger retrieved
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/deployed-triggers/{jsonable_encoder(trigger_id)}",
            method="GET",
            params={
                "external_user_id": external_user_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    GetTriggerResponse,
                    parse_obj_as(
                        type_=GetTriggerResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _data = _parsed_response.data
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        trigger_id: str,
        *,
        external_user_id: str,
        active: typing.Optional[bool] = OMIT,
        configured_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DeployedComponent]:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        active : typing.Optional[bool]
            Whether the trigger should be active

        configured_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The configured properties for the trigger

        name : typing.Optional[str]
            The name of the trigger

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DeployedComponent]
            deployed trigger updated
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/deployed-triggers/{jsonable_encoder(trigger_id)}",
            method="PUT",
            params={
                "external_user_id": external_user_id,
            },
            json={
                "active": active,
                "configured_props": configured_props,
                "name": name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    GetTriggerResponse,
                    parse_obj_as(
                        type_=GetTriggerResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _data = _parsed_response.data
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self,
        trigger_id: str,
        *,
        external_user_id: str,
        ignore_hook_errors: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        ignore_hook_errors : typing.Optional[bool]
            Whether to ignore errors during deactivation hook

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/deployed-triggers/{jsonable_encoder(trigger_id)}",
            method="DELETE",
            params={
                "external_user_id": external_user_id,
                "ignore_hook_errors": ignore_hook_errors,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list_events(
        self,
        trigger_id: str,
        *,
        external_user_id: str,
        n: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[EmittedEvent]]:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            Your end user ID, for whom you deployed the trigger

        n : typing.Optional[int]
            The number of events to retrieve (defaults to 20 if not provided)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[EmittedEvent]]
            trigger events retrieved
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/deployed-triggers/{jsonable_encoder(trigger_id)}/events",
            method="GET",
            params={
                "external_user_id": external_user_id,
                "n": n,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    GetTriggerEventsResponse,
                    parse_obj_as(
                        type_=GetTriggerEventsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _data = _parsed_response.data
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list_workflows(
        self, trigger_id: str, *, external_user_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetTriggerWorkflowsResponse]:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetTriggerWorkflowsResponse]
            trigger workflows retrieved
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/deployed-triggers/{jsonable_encoder(trigger_id)}/pipelines",
            method="GET",
            params={
                "external_user_id": external_user_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetTriggerWorkflowsResponse,
                    parse_obj_as(
                        type_=GetTriggerWorkflowsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_workflows(
        self,
        trigger_id: str,
        *,
        external_user_id: str,
        workflow_ids: typing.Sequence[str],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetTriggerWorkflowsResponse]:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        workflow_ids : typing.Sequence[str]
            Array of workflow IDs to set

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetTriggerWorkflowsResponse]
            trigger workflows updated
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/deployed-triggers/{jsonable_encoder(trigger_id)}/pipelines",
            method="PUT",
            params={
                "external_user_id": external_user_id,
            },
            json={
                "workflow_ids": workflow_ids,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetTriggerWorkflowsResponse,
                    parse_obj_as(
                        type_=GetTriggerWorkflowsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list_webhooks(
        self, trigger_id: str, *, external_user_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetTriggerWebhooksResponse]:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetTriggerWebhooksResponse]
            trigger webhooks retrieved
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/deployed-triggers/{jsonable_encoder(trigger_id)}/webhooks",
            method="GET",
            params={
                "external_user_id": external_user_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetTriggerWebhooksResponse,
                    parse_obj_as(
                        type_=GetTriggerWebhooksResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_webhooks(
        self,
        trigger_id: str,
        *,
        external_user_id: str,
        webhook_urls: typing.Sequence[str],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetTriggerWebhooksResponse]:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        webhook_urls : typing.Sequence[str]
            Array of webhook URLs to set

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetTriggerWebhooksResponse]
            trigger webhooks updated
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/deployed-triggers/{jsonable_encoder(trigger_id)}/webhooks",
            method="PUT",
            params={
                "external_user_id": external_user_id,
            },
            json={
                "webhook_urls": webhook_urls,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetTriggerWebhooksResponse,
                    parse_obj_as(
                        type_=GetTriggerWebhooksResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
