# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.create_o_auth_token_response import CreateOAuthTokenResponse
from .raw_client import AsyncRawOauthTokensClient, RawOauthTokensClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class OauthTokensClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawOauthTokensClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawOauthTokensClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawOauthTokensClient
        """
        return self._raw_client

    def create(
        self, *, client_id: str, client_secret: str, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateOAuthTokenResponse:
        """
        Parameters
        ----------
        client_id : str

        client_secret : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateOAuthTokenResponse
            token created

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.oauth_tokens.create(
            client_id="client_id",
            client_secret="client_secret",
        )
        """
        _response = self._raw_client.create(
            client_id=client_id, client_secret=client_secret, request_options=request_options
        )
        return _response.data


class AsyncOauthTokensClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawOauthTokensClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawOauthTokensClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawOauthTokensClient
        """
        return self._raw_client

    async def create(
        self, *, client_id: str, client_secret: str, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateOAuthTokenResponse:
        """
        Parameters
        ----------
        client_id : str

        client_secret : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateOAuthTokenResponse
            token created

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.oauth_tokens.create(
                client_id="client_id",
                client_secret="client_secret",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            client_id=client_id, client_secret=client_secret, request_options=request_options
        )
        return _response.data
