# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..types.create_token_response import CreateTokenResponse
from ..types.validate_token_params import ValidateTokenParams
from ..types.validate_token_response import ValidateTokenResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawTokensClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create(
        self,
        *,
        external_user_id: str,
        project_id: str,
        allowed_origins: typing.Optional[typing.Sequence[str]] = OMIT,
        error_redirect_uri: typing.Optional[str] = OMIT,
        success_redirect_uri: typing.Optional[str] = OMIT,
        webhook_uri: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CreateTokenResponse]:
        """
        Parameters
        ----------
        external_user_id : str
            Your end user ID, for whom you're creating the token

        project_id : str
            The ID of the project

        allowed_origins : typing.Optional[typing.Sequence[str]]
            List of allowed origins for CORS

        error_redirect_uri : typing.Optional[str]
            URI to redirect to on error

        success_redirect_uri : typing.Optional[str]
            URI to redirect to on success

        webhook_uri : typing.Optional[str]
            Webhook URI for notifications

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CreateTokenResponse]
            connect token created
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/connect/tokens",
            method="POST",
            json={
                "allowed_origins": allowed_origins,
                "error_redirect_uri": error_redirect_uri,
                "external_user_id": external_user_id,
                "project_id": project_id,
                "success_redirect_uri": success_redirect_uri,
                "webhook_uri": webhook_uri,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateTokenResponse,
                    parse_obj_as(
                        type_=CreateTokenResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def validate(
        self,
        ctok: str,
        *,
        params: typing.Optional[ValidateTokenParams] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ValidateTokenResponse]:
        """
        Parameters
        ----------
        ctok : str

        params : typing.Optional[ValidateTokenParams]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ValidateTokenResponse]
            connect token validated
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/connect/tokens/{jsonable_encoder(ctok)}/validate",
            method="GET",
            params={
                "params": convert_and_respect_annotation_metadata(
                    object_=params, annotation=ValidateTokenParams, direction="write"
                ),
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ValidateTokenResponse,
                    parse_obj_as(
                        type_=ValidateTokenResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawTokensClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create(
        self,
        *,
        external_user_id: str,
        project_id: str,
        allowed_origins: typing.Optional[typing.Sequence[str]] = OMIT,
        error_redirect_uri: typing.Optional[str] = OMIT,
        success_redirect_uri: typing.Optional[str] = OMIT,
        webhook_uri: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CreateTokenResponse]:
        """
        Parameters
        ----------
        external_user_id : str
            Your end user ID, for whom you're creating the token

        project_id : str
            The ID of the project

        allowed_origins : typing.Optional[typing.Sequence[str]]
            List of allowed origins for CORS

        error_redirect_uri : typing.Optional[str]
            URI to redirect to on error

        success_redirect_uri : typing.Optional[str]
            URI to redirect to on success

        webhook_uri : typing.Optional[str]
            Webhook URI for notifications

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CreateTokenResponse]
            connect token created
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/connect/tokens",
            method="POST",
            json={
                "allowed_origins": allowed_origins,
                "error_redirect_uri": error_redirect_uri,
                "external_user_id": external_user_id,
                "project_id": project_id,
                "success_redirect_uri": success_redirect_uri,
                "webhook_uri": webhook_uri,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateTokenResponse,
                    parse_obj_as(
                        type_=CreateTokenResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def validate(
        self,
        ctok: str,
        *,
        params: typing.Optional[ValidateTokenParams] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ValidateTokenResponse]:
        """
        Parameters
        ----------
        ctok : str

        params : typing.Optional[ValidateTokenParams]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ValidateTokenResponse]
            connect token validated
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/connect/tokens/{jsonable_encoder(ctok)}/validate",
            method="GET",
            params={
                "params": convert_and_respect_annotation_metadata(
                    object_=params, annotation=ValidateTokenParams, direction="write"
                ),
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ValidateTokenResponse,
                    parse_obj_as(
                        type_=ValidateTokenResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
