# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .app_auth_type import AppAuthType


class App(UniversalBaseModel):
    """
    Response object for a Pipedream app's metadata
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the app. Only applies for OAuth apps.
    """

    name_slug: str = pydantic.Field()
    """
    The name slug of the target app (see https://pipedream.com/docs/connect/quickstart#find-your-apps-name-slug)
    """

    name: str = pydantic.Field()
    """
    The human-readable name of the app
    """

    auth_type: typing.Optional[AppAuthType] = pydantic.Field(default=None)
    """
    The authentication type used by the app
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    A short description of the app
    """

    img_src: str = pydantic.Field()
    """
    The URL to the app's logo
    """

    custom_fields_json: typing.Optional[str] = pydantic.Field(default=None)
    """
    A JSON string representing the custom fields for the app
    """

    categories: typing.List[str] = pydantic.Field()
    """
    Categories associated with the app
    """

    featured_weight: float = pydantic.Field()
    """
    A rough directional ordering of app popularity, subject to changes by Pipedream
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
