![Logo](https://raw.githubusercontent.com/DSecureMe/vmc/master/images/vmp.png)

![master](https://github.com/DSecureMe/vmc/actions/workflows/main.yml/badge.svg?branch=master) [![codecov](https://codecov.io/gh/DSecureMe/vmc/branch/master/graph/badge.svg)](https://codecov.io/gh/DSecureMe/vmc) [![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](https://opensource.org/licenses/Apache-2.0) [![PyPI version](https://badge.fury.io/py/vmcenter.svg)](https://badge.fury.io/py/vmcenter)
[![Codacy Badge](https://api.codacy.com/project/badge/Grade/7e6cbf0a970e4b19963bc3a63f843bf7)](https://www.codacy.com/gh/DSecureMe/vmc?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=DSecureMe/vmc&amp;utm_campaign=Badge_Grade)

**[VMC](https://owasp.org/www-project-vulnerability-management-center/)** (OWASP Vulnerability Management Center) is a platform designed to make vulnerability governance easier for any security specialists and SOC teams within their organisations. VMC is a great partner in any vulnerability management process, allowing automation and making your life easier. You can integrate VMC with vulnerability scanners and platforms like [TheHive](https://github.com/TheHive-Project/TheHive). Additionally, VMC takes care of asset management integrating with [Ralph](https://github.com/allegro/ralph), whole vulnerability reporting and dashboards ([Kibana](https://github.com/elastic/kibana)) for the clear overview. VMC allows you to focus on the most important vulnerability issues within your environment.

# Value for business
Thanks to VMC you can focus on the most important assets from environment perspective given information about vulnerabilities and assets.

VMC can present important information in brief and compact way
![screen3](https://raw.githubusercontent.com/DSecureMe/vmc/master/images/kpi_1.png)

![screen4](https://raw.githubusercontent.com/DSecureMe/vmc/master/images/kpi_2.png)

![screen5](https://raw.githubusercontent.com/DSecureMe/vmc/master/images/67130855_394264208112259_8200620034528116736_n.png)

VMC also shows live updates regarding you environemnt. It guides your focus to specific threats and assets.

![screen1](https://raw.githubusercontent.com/DSecureMe/vmc/master/images/hive.png)

![screen2](https://raw.githubusercontent.com/DSecureMe/vmc/master/images/alerts.png)

You can install VMC either on your machine or use elegant [docker solution](https://github.com/DSecureMe/vmc-docker).

# Details
## Documentation
We’ve made separate repository with guides and documentation available [here](https://github.com/DSecureMe/vmc-docs).
## Architecture
In simple words VMC requires data about detections from your scanner, information about assets and updates about CVE. Thanks to that VMC can live update your focus to the most emerging threats for your assets.
## License
Source code in this repository is covered by one of three licenses:
* the Apache License 2.0 https://www.apache.org/licenses/LICENSE-2.0
* the Apache License 2.0 compatible license
* the DSecure.me License.
The default license throughout the repository is Apache License 2.0 unless the header specifies another license.

# Try it
We encourage you to try our demo instance. You can get it from [here](https://github.com/DSecureMe/vmc-demo)
Instruction how to use it is in the demo [readme](https://github.com/DSecureMe/vmc-demo/blob/main/README.md) file


# Contributing
Please see our [Code of conduct](https://github.com/DSecureMe/vmc/blob/master/CODE_OF_CONDUCT.md). We welcome your contributions. Please feel free to fork the code, play with it, make some patches and send us pull requests via issues. At this [link](https://github.com/DSecureMe/vmc-dev-toolkit) you can find the dev toolkit to help you get start.

# Support
Please [open an issue on GitHub](https://github.com/DSecureMe/vmc/issues) if you'd like to report a bug or request a feature.

If you need to contact the project team, send an email to vmc-support@dsecure.me

# Website
https://dsecure.me
