configuration = {
  "generic_constraints":[
    {
      "name":"fk_file_id",
      "type":"foreign key",
      "columns":[
        "file_id"
      ],
      "reference_table_name":"files",
      "reference_schema_name":"public",
      "reference_columns":[
        "id"
      ]
    }
  ],
  "vocabulary":[
    "table",
    "schema",
    "date",
    "rows",
    "int",
    "numeric",
    "text",
    "timestamp",
    "in",
    "order"
  ],
  "elements":{
    "role":{
      "attributes":[
        {
          "name":"id",
          "type":"int"
        },
        {
          "name":"name",
          "type":"string",
          "setter":"rename"
        },
        {
          "name":"status",
          "type":"string",
          "default":"developpement",
          "values":[
            "default",
            "inexistant",
            "inactive",
            "developpement",
            "test",
            "production"
          ]
        },
        {
          "name":"is_superuser",
          "type":"boolean",
          "default":False
        },
        {
          "name":"can_create_database",
          "type":"boolean",
          "default":False
        }
      ],
      "defaults":[
        {
          "name":"postgres",
          "status":"production",
          "is_superuser":True,
          "can_create_database":True
        }
      ]
    },
    "database":{
      "attributes":[
        {
          "name":"name",
          "type":"string",
          "setter":"rename"
        },
        {
          "name":"owner_id",
          "type":"int",
          "database_name":"owner",
          "element_type":"role",
          "default":"postgres",
          "setter":"setOwner"
        },
        {
          "name":"status",
          "default":"developpement",
          "values":[
            "default",
            "inexistant",
            "inactive",
            "developpement",
            "test",
            "production"
          ]
        },
        {
          "name":"grants",
          "type":"list",
          "setter":"manageGrants",
          "sub":{
            "type":"dict",
            "attributes":{}
          }
        }
      ]
    },
    "extension":{
      "attributes":[
        {
          "name":"id",
          "type":"int"
        },
        {
          "name":"name",
          "type":"string",
          "setter":"rename"
        },
        {
          "name":"status",
          "default":"developpement",
          "values":[
            "default",
            "inexistant",
            "inactive",
            "developpement",
            "test",
            "production"
          ]
        }
      ],
      "defaults":[
        {
          "name":"postgis",
          "status":"production"
        }
      ]
    },
    "schema":{
      "attributes":[
        {
          "name":"id",
          "type":"int"
        },
        {
          "name":"name",
          "type":"string",
          "setter":"rename"
        },
        {
          "name":"status",
          "default":"developpement",
          "type":"categorical",
          "values":[
            "default",
            "inexistant",
            "inactive",
            "developpement",
            "test",
            "production"
          ]
        },
        {
          "name":"owner_id",
          "type":"int",
          "database_name":"owner",
          "element_type":"role",
          "default":"postgres",
          "setter":"setOwner"
        },
        {
          "name":"schema_type",
          "type":"string",
          "default":"source",
          "values":[
            "source",
            "outcome"
          ]
        },
        {
          "name":"content",
          "default":{        
            "name": None,
            "description":None,
            "content_elements": []
          }
        },
        {
          "name":"grants",
          "setter":"manageGrants"
        },
        {
          "name":"size"
        }
      ],
      "sub_elements":[
        "table",
        "view",
        "function"
      ],
      "defaults":[
        {
          "name":"public",
          "status":"production",
          "schema_type":"source",
          "content": {
            "name": None,
            "description":None,
            "content_elements": []
          },
          "owner_id":None,
          "grants": [
            {
              "privilege": "usage",
              "user_name": "postgres"
            },
            {
              "privilege": "create",
              "user_name": "postgres"
            }
          ]
        }
      ]
    },
    "table":{
      "attributes":[
        {
          "name":"id",
          "type":"int"
        },
        {
          "name":"name",
          "type":"string",
          "setter":"rename"
        },
        {
          "name":"owner_id",
          "type":"int",
          "database_name":"owner",
          "element_type":"role",
          "default":"postgres",
          "setter":"setOwner"
        },
        {
          "name":"schema_id",
          "type":"int",
          "database_name":"schema_name",
          "element_type":"schema",
          "default":"public",
          "setter":"setSchema",
          "extra_attribute":"schema_type"
        },
        {
          "name":"status",
          "default":"developpement",
          "values":[
            "default",
            "inexistant",
            "inactive",
            "developpement",
            "test",
            "production"
          ]
        },
        {
          "name":"columns",
          "type":"list",
          "default":[],
          "setter":"manageColumns"
        },
        {
          "name":"constraints",
          "type":"list",
          "default":[],
          "setter":"manageConstraints"
        },
        {
          "name":"indexes",
          "type":"list",
          "default":[],
          "setter":"manageIndexes"
        },
        {
          "name":"grants",
          "type":"list",
          "default":[],
          "setter":"manageGrants"
        },
        {
          "name":"size"
        },
        {
          "name":"content",
          "type":"dict",
          "default":{
            "name": None,
            "description":None,
            "content_elements": []
          }
        },
        {
          "name":"partitions",
          "type":"dict",
          "default":{},
          "setter":"managePartition"
        }
      ],
      "sub_elements":[
        "index",
        "column",
        "constraint"
      ],
      "configs":[
        {
            "name":"files",
            "schema_name": "public",
            "status":"production",
            "columns":[
                {
                    "name":"id",
                    "type":"int",
                    "serial":True,
                    "constraints":[
                        {
                            "name":"files_pk",
                            "type":"primary key"
                        },
                        {
                            "name":"id_not_None",
                            "type":"not_None"
                        }
                    ]
                },
                {
                    "name":"path_index",
                    "type":"text",
                    "constraints":[
                        {
                            "name":"unique_path_index",
                            "type":"unique"
                        }
                    ]
                },
                {
                    "name":"name",
                    "type":"text",
                    "constraints":[
                        {
                            "name":"name_not_None",
                            "type":"not_None"
                        }
                    ]
                },
                {
                    "name":"main_files",
                    "type":"json[]"
                },
                {
                    "name":"schema",
                    "type":"text"
                },
                {
                    "name":"tables",
                    "type":"text[]"
                },
                {
                    "name":"modification_time",
                    "type":"timestamp"
                },
                {
                    "name":"size",
                    "type":"bigint"
                },
                {
                    "name":"rows",
                    "type":"bigint"
                },
                {
                    "name":"directory_name",
                    "type":"text"
                },
                {
                    "name":"columns",
                    "type":"text[]"
                },
                {
                    "name":"status",
                    "type":"text"
                }
            ],
            "constraints":[
                {
                    "name":"files_pk",
                    "type":"primary key",
                    "columns":[
                        "id"
                    ]
                },
                {   
                    "name":"unique_path_index",
                    "type":"unique",
                    "columns":[
                        "path_index"
                    ]
                }
            ],
            "indexes":[],
            "partitions":{}
        },
        {
            "name":"data_events",
            "schema_name": "public",
            "columns":[
                {
                    "name":"id",
                    "type":"int",
                    "serial":True,
                    "constraints":[
                        {
                            "name":"data_events_pk",
                            "type":"primary_key"
                        },
                        {
                            "name":"id_not_None",
                            "type":"not_None"
                        }
                    ]
                },
                {
                    "name":"name",
                    "type":"text"
                },
                {
                    "name":"element_type",
                    "type":"text"
                },
                {
                    "name":"element_id",
                    "type":"text"
                },
                {
                    "name":"element_name",
                    "type":"text"
                },
                {
                    "name":"element_schema_name",
                    "type":"text"
                },
                {
                    "name":"event_time",
                    "type":"timestamp"
                },
                {
                    "name":"duration",
                    "type":"numeric"
                },
                {
                  "name":"action_name",
                  "type":"text"
                },
                {
                  "name":"action_time",
                  "type":"timestamp"
                },
                {
                  "name":"action_element_type",
                  "type":"text"
                },
                {
                  "name":"action_element_id",
                  "type":"text"
                },
                {
                  "name":"action_element_name",
                  "type":"text"
                },
                {
                  "name":"action_element_schema_name",
                  "type":"text"
                },
                {
                  "name":"informations",
                  "type":"jsonb "
                }
            ],
            "constraints":[
                {
                    "name":"data_events_pk",
                    "type":"primary key",
                    "columns":[
                        "id"
                    ]
                }
            ],
            "indexes":[],
            "partitions":{}
        }
      ]
    },
    "view":{
      "attributes":[
        {
          "name":"id",
          "type":"int"
        },
        {
          "name":"name",
          "type":"string",
          "setter":"rename"
        },
        {
          "name":"owner_id",
          "default":"postgres",
          "element_type":"role",
          "setter":"setOwner",
          "database_name":"owner",
          "foreign_attribute":"name"
        },
        {
          "name":"schema_id",
          "default":"public",
          "element_type":"schema",
          "setter":"setSchema",
          "database_name":"schema_name",
          "foreign_attribute":"name"
        },
        {
          "name":"status",
          "default":"developpement",
          "values":[
            "default",
            "inexistant",
            "inactive",
            "developpement",
            "test",
            "production"
          ]
        },
        {
          "name":"columns",
          "default":[]
        },
        {
          "name":"indexes",
          "default":[],
          "setter":"manageIndexes"
        },
        {
          "name":"grants",
          "default":[],
          "setter":"manageGrants"
        },
        {
          "name":"size",
          "default":0
        },
        {
          "name":"content",
          "default":{        
            "name": None,
            "description":None,
            "content_elements": []
          }
        },
        {
          "name":"is_materialized",
          "default":False
        },
        {
          "name":"is_database_saved",
          "default":False
        },
        {
          "name":"query",
          "default":False
        },
        {
          "name":"file_query",
          "default":False
        },
        {
          "name":"directory_query",
          "default":False
        }
      ],
      "sub_elements":[
        "index",
        "column",
        "constraint"
      ]
    },
    "function":{
      "attributes":[
        {
          "name":"id",
          "type":"int"
        },
        {
          "name":"name",
          "type":"string",
          "setter":"rename"
        },
        {
          "name":"schema_id",
          "default":"public",
          "element_type":"schema",
          "setter":"setSchema",
          "database_name":"schema_name",
          "foreign_attribute":"name"
        },
        {
          "name":"status",
          "default":"developpement",
          "values":[
            "default",
            "inexistant",
            "inactive",
            "developpement",
            "test",
            "production"
          ]
        },
        {
          "name":"owner_id",
          "default":"postgres",
          "element_type":"role",
          "setter":"setOwner",
          "database_name":"owner",
          "foreign_attribute":"name"
        },
        {
          "name":"columns",
          "default":[]
        },
        {
          "name":"indexes",
          "default":[]
        },
        {
          "name":"grants",
          "default":[],
          "setter":"grants"
        },
        {
          "name":"size",
          "default":0
        },
        {
          "name":"sizes",
          "default":{
            "developpement":None,
            "test":None,
            "production":None
          }
        },
        {
          "name":"id",
          "default":None
        },
        {
          "name":"content",
          "default":None
        },
        {
          "name":"is_materialized",
          "default":False
        },
        {
          "name":"query",
          "default":False
        },
        {
          "name":"file_query",
          "default":False
        },
        {
          "name":"directory_query",
          "default":False
        }
      ],
      "sub_elements":[
        "index",
        "column",
        "constraint"
      ]
    },
    "data_source":{
      "attributes":[
        {
          "name":"id",
          "type":"int"
        },
        {
          "name":"name",
          "type":"string"
        },
        {
          "name":"status",
          "default":"developpement",
          "values":[
            "default",
            "inexistant",
            "inactive",
            "developpement",
            "test",
            "production"
          ]
        },
        {
          "name":"content",
          "default":{        
            "name": None,
            "description":None,
            "content_elements": []
          }
        },
        {
          "name":"fetch",
          "default":[]
        },
        {
          "name":"extract",
          "default":[]
        },
        {
          "name":"transform",
          "default":[]
        },
        {
          "name":"save",
          "default":[]
        },
        {
          "name":"schema_id",
          "default":"public",
          "element_type":"schema",
          "setter":"setSchema",
          "database_name":"schema_name",
          "foreign_attribute":"name"
        },
        {
          "name":"tables",
          "default":[],
          "type":"list"
        },
        {
          "name":"control",
          "default":{
            "extensions": None,
            "ignored_elements": None,
            "sub_element_contain": None,
            "start_string": None
          }
        },
        {
          "name":"directory_name"
        },
        {
          "name":"data_version",
          "default":{
            "values": [],
            "tables": []
          }
        },
        {
          "name":"views",
          "default":[],
          "type":"list"
        }
      ],
      "sub_elements":[
        "file"
      ]
    },
    "data_process":{
      "attributes":[
        {
          "name":"id",
          "type":"int"
        },
        {
          "name":"name",
          "type":"string"
        },
        {
          "name":"status",
          "default":"developpement",
          "values":[
            "default",
            "inexistant",
            "inactive",
            "developpement",
            "test",
            "production"
          ]
        },
        {
          "name":"content",
          "default":{        
            "name": None,
            "description":None,
            "content_elements": []
          }
        },
        {
          "name":"schema_id",
          "default":"public",
          "element_type":"schema",
          "setter":"setSchema",
          "database_name":"schema_name",
          "foreign_attribute":"name"
        },
        {
          "name":"actions"
        }
      ],
      "sub_elements":[
        "file"
      ]
    }
  }
}