from typing import Any, Iterable, overload, Sequence, Type, Union

def str_to_bits_rust(s: str) -> 'Bits': ...
def set_dtype_parser(dtype_parser: object) -> None: ...
def bits_from_any(any: object) -> 'Bits': ...
def mutable_bits_from_any(any: object) -> 'MutableBits': ...

class Bits:
    def __init__(self, s: str | None = None) -> None: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __iter__(self) -> 'BitsBoolIterator': ...
    def __eq__(self, other: object) -> bool: ...
    def __len__(self) -> int: ...
    @overload
    def __getitem__(self, key: int) -> bool: ...
    @overload
    def __getitem__(self, key: slice) -> 'Bits': ...
    def __getitem__(self, key: Union[int, slice]) -> Union[bool, 'Bits']: ...
    def __lshift__(self, n: int) -> 'Bits': ...
    def __rshift__(self, n: int) -> 'Bits': ...
    def __invert__(self) -> 'Bits': ...

    @staticmethod
    def _from_u64(value: int, length: int) -> 'Bits': ...
    @staticmethod
    def _from_i64(value: int, length: int) -> 'Bits': ...
    def _to_u64(self, start: int, length: int) -> int: ...
    def _to_i64(self, start: int, length: int) -> int: ...
    def _findall(self, needle_obj: 'Bits', byte_aligned: bool = False) -> 'PyBitsFindAllIterator': ...

    @classmethod
    def from_zeros(cls: Type['Bits'], length: int) -> 'Bits': ...
    @classmethod
    def from_ones(cls: Type['Bits'], length: int) -> 'Bits': ...
    @classmethod
    def from_bytes(cls: Type['Bits'], data: bytes) -> 'Bits': ...

    @staticmethod
    def _from_bytes_with_offset(data: bytes, offset: int) -> 'Bits': ...
    @staticmethod
    def _from_bools(values: Iterable[bool]) -> 'Bits': ...
    @staticmethod
    def _from_bin(binary_string: str) -> 'Bits': ...
    @staticmethod
    def _from_hex(hex: str) -> 'Bits': ...
    @staticmethod
    def _from_oct(oct: str) -> 'Bits': ...
    @staticmethod
    def _from_joined(bits_vec: Iterable['Bits']) -> 'Bits': ...

    def _to_int_byte_data(self, signed: bool) -> bytes: ...
    def to_bytes(self) -> bytes: ...
    def _slice_to_bytes(self, start: int, length: int) -> bytes: ...
    def _slice_to_bin(self, start: int, length: int) -> str: ...
    def _slice_to_oct(self, start: int, length: int) -> str: ...
    def _slice_to_hex(self, start: int, length: int) -> str: ...

    def _and(self, other: 'Bits') -> 'Bits': ...
    def _or(self, other: 'Bits') -> 'Bits': ...
    def _xor(self, other: 'Bits') -> 'Bits': ...

    def _find(self, b: 'Bits', start: int, bytealigned: bool) -> int | None: ...
    def _rfind(self, b: 'Bits', start: int, bytealigned: bool) -> int | None: ...

    def count(self, value: Any) -> int: ...
    def _getslice(self, start_bit: int, end_bit: int) -> 'Bits': ...
    def _get_slice_unchecked(self, start_bit: int, length: int) -> 'Bits': ...
    def _getslice_with_step(self, start_bit: int, end_bit: int, step: int) -> 'Bits': ...
    def all(self) -> bool: ...
    def any(self) -> bool: ...
    def to_mutable_bits(self) -> 'MutableBits': ...
    def _clone_as_immutable(self) -> 'Bits': ...
    def _getindex(self, bit_index: int) -> bool: ...

class MutableBits:
    def __eq__(self, other: object) -> bool: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __len__(self) -> int: ...
    @overload
    def __getitem__(self, key: int) -> bool: ...
    @overload
    def __getitem__(self, key: slice) -> 'MutableBits': ...
    def __getitem__(self, key: Union[int, slice]) -> Union[bool, 'MutableBits']: ...
    def __invert__(self) -> 'MutableBits': ...
    def __lshift__(self, n: int) -> 'MutableBits': ...
    def __rshift__(self, n: int) -> 'MutableBits': ...

    def _byte_swap(self) -> None: ...
    def _overwrite(self, start: int, value: 'Bits') -> None: ...
    def _set_slice(self, start: int, end: int, value: 'Bits') -> None: ...
    def _ixor(self, other: 'MutableBits') -> None: ...
    def _ior(self, other: 'MutableBits') -> None: ...
    def _iand(self, other: 'MutableBits') -> None: ...
    def _or(self, other: 'Bits') -> 'MutableBits': ...
    def _and(self, other: 'Bits') -> 'MutableBits': ...
    def _xor(self, other: 'Bits') -> 'MutableBits': ...

    @staticmethod
    def _from_u64(value: int, length: int) -> 'MutableBits': ...
    @staticmethod
    def _from_i64(value: int, length: int) -> 'MutableBits': ...
    @classmethod
    def from_zeros(cls: Type['MutableBits'], length: int) -> 'MutableBits': ...
    @classmethod
    def from_ones(cls: Type['MutableBits'], length: int) -> 'MutableBits': ...
    @staticmethod
    def _from_bools(values: Iterable[bool]) -> 'MutableBits': ...
    @classmethod
    def from_bytes(cls: Type['MutableBits'], data: bytes) -> 'MutableBits': ...
    @staticmethod
    def _from_bytes_with_offset(data: bytes, offset: int) -> 'MutableBits': ...
    @staticmethod
    def _from_bin_checked(binary_string: str) -> 'MutableBits': ...
    @staticmethod
    def _from_hex_checked(hex: str) -> 'MutableBits': ...
    @staticmethod
    def _from_oct_checked(oct: str) -> 'MutableBits': ...
    @staticmethod
    def _from_joined(py_bits_vec: Iterable['Bits']) -> 'MutableBits': ...

    def _to_u64(self, start: int, length: int) -> int: ...
    def _to_i64(self, start: int, length: int) -> int: ...
    def _getindex(self, bit_index: int) -> bool: ...
    def _getslice(self, start_bit: int, end_bit: int) -> 'MutableBits': ...
    def _get_slice_unchecked(self, start_bit: int, length: int) -> 'MutableBits': ...
    def _getslice_with_step(self, start_bit: int, end_bit: int, step: int) -> 'MutableBits': ...
    def to_bytes(self) -> bytes: ...
    def _slice_to_bin(self, start: int, end: int) -> str: ...
    def _slice_to_oct(self, start: int, end: int) -> str: ...
    def _slice_to_hex(self, start: int, end: int) -> str: ...
    def _slice_to_bytes(self, start: int, end: int) -> bytes: ...
    def _to_int_byte_data(self, signed: bool) -> bytes: ...
    def count(self, value: Any) -> int: ...
    def all(self) -> bool: ...
    def any(self) -> bool: ...
    def _find(self, b: 'Bits', start: int, bytealigned: bool) -> int | None: ...
    def _rfind(self, b: 'Bits', start: int, bytealigned: bool) -> int | None: ...
    @overload
    def invert(self) -> 'MutableBits': ...
    @overload
    def invert(self, pos: int | Iterable[int]) -> 'MutableBits': ...
    def invert(self, pos: int | Iterable[int] | None = None) -> 'MutableBits': ...
    def reverse(self) -> 'MutableBits': ...
    def _set_from_sequence(self, value: bool, indices: Sequence[int]) -> None: ...
    def _set_index(self, value: bool, index: int) -> None: ...
    def _set_from_slice(self, value: bool, start: int, stop: int, step: int) -> None: ...
    def __copy__(self) -> 'MutableBits': ...
    def to_bits(self) -> 'Bits': ...
    def _as_immutable(self) -> 'Bits': ...
    def append(self, bs: Any) -> 'MutableBits': ...
    def prepend(self, bs: Any) -> 'MutableBits': ...
    def _lshift_inplace(self, n: int) -> None: ...
    def _rshift_inplace(self, n: int) -> None: ...

class PyBitsFindAllIterator:
    def __iter__(self) -> 'PyBitsFindAllIterator': ...
    def __next__(self) -> int: ...

class BitsBoolIterator:
    def __iter__(self) -> 'BitsBoolIterator': ...
    def __next__(self) -> bool: ...