# Solution File Structure

## Pre-assembly

This is the expected file structure for a solution before the assembler is run (i.e. when it is cloned from its source repository on GitHub).

**File structure as downloaded:**

```default
.
├── solution_config/
│   ├── .env    # (optional) used to define docker compose variables
│   ├── source_config/
│   │   └── <source_name>/  # required for all sources
│   │       └── ...     # module config for each source (differs by source)
│   └── user_config_templates/
│       └── <source_name>/  # (optional - not required for all sources)
│           ├── __templating/
│           │   ├── __version__     # template version (used to manage config format updates)
│           │   ├── prompts.toml    # (optional) specifies user_config prompts
│           │   └── defaults.json   # (optional) default answers to prompts
│           └── ... # template config files using jinja2 format for variable replacement
├── .gitignore  # see below
├── LICENSE
├── README.MD 
└── recipe.toml

```

### .gitignore

At a minimum, the .gitignore should include the following entries:

```default
data/**
assembled/**
```

## Post-Assembly

All files generated by the assembler are located in `assembled/`. The assembler also creates a `data/` directory where all of the service_module data volumes are stored

**File structure after assembly:**

```default
.
├── assembled/ 
│   ├── sources/  
│   │   └── <source_name>/       
│   │       ├── meta.toml        
│   │       ├── snippet.yaml     # filename may differ - set in meta file
│   │       ├── Dockerfile       # filename may differ - set in meta file
│   │       └── ...              # rest of source contents
│   ├── compiled_user_config/
│   │   └── <service_module_name>/  
│   │       ├── __templating/       
│   │       │   ├── __version__          # template version used to generate these user config files
│   │       │   └── prev_answers.json    # (optional) answers given to prompts (if prompts.toml present)
│   │       └── ...  # config files generated from templates
│   └── compose.yml # generated compose file
├── data/ 
│   └── <service_module_name>/  
│       └── ...  # data volume mounts used to persist service 
├── solution_config/
│   └── ...
└── ...
```
