# Service Module Sources

## Filestructure

The diagram below indicates a typical file structure for a service module source. The only required file is the `meta.toml` file. The `Dockerfile` and the `snippet.yml` file are required but may have a different name.

```default
.
├── code/
│   └── ... # solution code
├── LICENSE
├── .gitignore
├── README.MD 
├── Dockerfile 
├── snippet.yml
└── meta.toml
```

> Typical file structure

## meta.toml

```toml
[<container_name>]
    dockerfile = "<filename>"
    compose_partial = "<filename>"

    volume.<name>.path = "<path>"
    volume.<name>.mode = "<ro|rw>"
    # or
    volume.<name>.ignore = true

    ports.<name> = <container_port>

[<second_container_name>] # (optional)
    ...
```

### `<container_name>` (and `<second_container_name>`)

The `meta.toml` file contains specifications for one or more containers. Each container specification should have a unique name, for example:

```toml
[app]
    ...
```

This name is referenced by the solution recipe.

### `dockerfile`

The name of the dockerfile to use when building this container. Typically the value would be `dockerfile = "Dockerfile"` for single container solutions, however this configuration option caters for scenarios where there are multiple containers which are build from different dockerfiles.

> See the section below for more details on the contents of the Dockerfile

### `compose_partial` (also referred to as a snippets file)

The contents of this file are combined with the content generated by the assembler to form the entry for the container in the docker compose file.

This entry is present to differentiate between different containers (like the `dockerfile` entry above)

> See the section below for more details on the contents of the snippets file

### `volume.<name>`

This entry is for specifying the container side mapping of volumes. Each volume must have a unique `name` the names `data` and `user_config` are special and will always have a host entries at `<solution_directory>/data/<service_module_name>` and `<solution_directory>/user_config/<service_module_name>` respectively.

Each container side mapping is specified with a `path` and a `mode`. The `path` is the filepath within the container where the volume is mounted. The `mode` is either `"ro"` - if it is read-only, or `"rw"` for read-write. If `mode` is not specified, `"rw"` is the default.

If a host volume entry is not going to be used, it should be specified using `volume.<name>.ignore = true`
(this is primarily there for cases where the `data` and/or `user_config` volumes aren’t used, but may be useful in other scenarios too).

### `ports.<name>`

This entry specifies the container side port for a port mapping. This is discussed in more detail in the corresponding [recipe section](recipe.md#Service-Modules).

## Dockerfile

The Dockerfile can be written as normal. The build context is configured as `solution_files/sources/<source_name>`. This means that all host filepaths are relative to and restricted to this context.

For example:
`COPY ./file.txt /app/data.txt` will copy the file `solution_files/sources/<source_name>/file.txt` from the host to `/app/data.txt` in the container

The compose file also configures an additional build context named `solution_config` located at
`solution_files/config/<source_name>` which allows the dockerfile to reference the module config directory for the source.
It can be used as follows:

```dockerfile
COPY --from=solution_config <path relative to module config> <container path>
```

For example:

`COPY --from=solution_config ./config.txt /app/config.txt`
would copy the file at `solution_files/config/<source_name>/config.txt` to `/app/config.txt`

## Compose Partial or Snippet file

The compose partial file is used to add entries to the compose file for a container.

In the example below, it is used to define the start-up command and to map in a device entry.

```yaml
command: ["python", "main.py", "--log", "{{log_level}}"]
devices:
  - /dev/input:/dev/input:ro
x-shoestring-setup-command: ["python","setup.py"]
```

> Example snippet.yml file from barcode scanning service module

Take note of the `x-shoestring-setup-command` entry - this is used to define a setup command (in the same format as compose’s `command` entry) which will be run by the assembler during the setup phase (see [here]() for more details).
