"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class AnalyticsCitiesTypedDict(TypedDict):
    country: str
    r"""The 2-letter ISO 3166-1 country code of the country where this city is located. Learn more: https://d.to/geo"""
    region: str
    r"""The 2-letter ISO 3166-2 region code representing the region associated with the location of the user."""
    city: str
    r"""The name of the city"""
    clicks: NotRequired[float]
    r"""The number of clicks from this city"""
    leads: NotRequired[float]
    r"""The number of leads from this city"""
    sales: NotRequired[float]
    r"""The number of sales from this city"""
    sale_amount: NotRequired[float]
    r"""The total amount of sales from this city, in cents"""


class AnalyticsCities(BaseModel):
    country: str
    r"""The 2-letter ISO 3166-1 country code of the country where this city is located. Learn more: https://d.to/geo"""

    region: str
    r"""The 2-letter ISO 3166-2 region code representing the region associated with the location of the user."""

    city: str
    r"""The name of the city"""

    clicks: Optional[float] = 0
    r"""The number of clicks from this city"""

    leads: Optional[float] = 0
    r"""The number of leads from this city"""

    sales: Optional[float] = 0
    r"""The number of sales from this city"""

    sale_amount: Annotated[Optional[float], pydantic.Field(alias="saleAmount")] = 0
    r"""The total amount of sales from this city, in cents"""
