"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class AnalyticsRefererUrlsTypedDict(TypedDict):
    referer_url: str
    r"""The full URL of the referer. If unknown, this will be `(direct)`"""
    clicks: NotRequired[float]
    r"""The number of clicks from this referer to this URL"""
    leads: NotRequired[float]
    r"""The number of leads from this referer to this URL"""
    sales: NotRequired[float]
    r"""The number of sales from this referer to this URL"""
    sale_amount: NotRequired[float]
    r"""The total amount of sales from this referer to this URL, in cents"""


class AnalyticsRefererUrls(BaseModel):
    referer_url: Annotated[str, pydantic.Field(alias="refererUrl")]
    r"""The full URL of the referer. If unknown, this will be `(direct)`"""

    clicks: Optional[float] = 0
    r"""The number of clicks from this referer to this URL"""

    leads: Optional[float] = 0
    r"""The number of leads from this referer to this URL"""

    sales: Optional[float] = 0
    r"""The number of sales from this referer to this URL"""

    sale_amount: Annotated[Optional[float], pydantic.Field(alias="saleAmount")] = 0
    r"""The total amount of sales from this referer to this URL, in cents"""
