"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.types import BaseModel
from enum import Enum
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class AnalyticsRegionsCity(str, Enum):
    WILDCARD_ = "*"


class AnalyticsRegionsTypedDict(TypedDict):
    country: str
    r"""The 2-letter ISO 3166-1 country code of the country. Learn more: https://d.to/geo"""
    region: str
    r"""The 2-letter ISO 3166-2 region code of the region."""
    city: NotRequired[AnalyticsRegionsCity]
    clicks: NotRequired[float]
    r"""The number of clicks from this region"""
    leads: NotRequired[float]
    r"""The number of leads from this region"""
    sales: NotRequired[float]
    r"""The number of sales from this region"""
    sale_amount: NotRequired[float]
    r"""The total amount of sales from this region, in cents"""


class AnalyticsRegions(BaseModel):
    country: str
    r"""The 2-letter ISO 3166-1 country code of the country. Learn more: https://d.to/geo"""

    region: str
    r"""The 2-letter ISO 3166-2 region code of the region."""

    city: Optional[AnalyticsRegionsCity] = AnalyticsRegionsCity.WILDCARD_

    clicks: Optional[float] = 0
    r"""The number of clicks from this region"""

    leads: Optional[float] = 0
    r"""The number of leads from this region"""

    sales: Optional[float] = 0
    r"""The number of sales from this region"""

    sale_amount: Annotated[Optional[float], pydantic.Field(alias="saleAmount")] = 0
    r"""The total amount of sales from this region, in cents"""
