"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.types import BaseModel, Nullable, OptionalNullable, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class RegisteredDomainTypedDict(TypedDict):
    r"""The registered domain record."""

    id: str
    r"""The ID of the registered domain record."""
    created_at: str
    r"""The date the domain was created."""
    expires_at: str
    r"""The date the domain expires."""


class RegisteredDomain(BaseModel):
    r"""The registered domain record."""

    id: str
    r"""The ID of the registered domain record."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The date the domain was created."""

    expires_at: Annotated[str, pydantic.Field(alias="expiresAt")]
    r"""The date the domain expires."""


class DomainSchemaTypedDict(TypedDict):
    id: str
    r"""The unique identifier of the domain."""
    slug: str
    r"""The domain name."""
    placeholder: Nullable[str]
    r"""Provide context to your teammates in the link creation modal by showing them an example of a link to be shortened."""
    expired_url: Nullable[str]
    r"""The URL to redirect to when a link under this domain has expired."""
    not_found_url: Nullable[str]
    r"""The URL to redirect to when a link under this domain doesn't exist."""
    logo: Nullable[str]
    r"""The logo of the domain."""
    created_at: str
    r"""The date the domain was created."""
    updated_at: str
    r"""The date the domain was last updated."""
    registered_domain: Nullable[RegisteredDomainTypedDict]
    r"""The registered domain record."""
    verified: NotRequired[bool]
    r"""Whether the domain is verified."""
    primary: NotRequired[bool]
    r"""Whether the domain is the primary domain for the workspace."""
    archived: NotRequired[bool]
    r"""Whether the domain is archived."""
    asset_links: NotRequired[Nullable[str]]
    r"""assetLinks.json configuration file (for deep link support on Android)."""
    apple_app_site_association: NotRequired[Nullable[str]]
    r"""apple-app-site-association configuration file (for deep link support on iOS)."""


class DomainSchema(BaseModel):
    id: str
    r"""The unique identifier of the domain."""

    slug: str
    r"""The domain name."""

    placeholder: Nullable[str]
    r"""Provide context to your teammates in the link creation modal by showing them an example of a link to be shortened."""

    expired_url: Annotated[Nullable[str], pydantic.Field(alias="expiredUrl")]
    r"""The URL to redirect to when a link under this domain has expired."""

    not_found_url: Annotated[Nullable[str], pydantic.Field(alias="notFoundUrl")]
    r"""The URL to redirect to when a link under this domain doesn't exist."""

    logo: Nullable[str]
    r"""The logo of the domain."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The date the domain was created."""

    updated_at: Annotated[str, pydantic.Field(alias="updatedAt")]
    r"""The date the domain was last updated."""

    registered_domain: Annotated[
        Nullable[RegisteredDomain], pydantic.Field(alias="registeredDomain")
    ]
    r"""The registered domain record."""

    verified: Optional[bool] = False
    r"""Whether the domain is verified."""

    primary: Optional[bool] = False
    r"""Whether the domain is the primary domain for the workspace."""

    archived: Optional[bool] = False
    r"""Whether the domain is archived."""

    asset_links: Annotated[
        OptionalNullable[str], pydantic.Field(alias="assetLinks")
    ] = None
    r"""assetLinks.json configuration file (for deep link support on Android)."""

    apple_app_site_association: Annotated[
        OptionalNullable[str], pydantic.Field(alias="appleAppSiteAssociation")
    ] = None
    r"""apple-app-site-association configuration file (for deep link support on iOS)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "verified",
            "primary",
            "archived",
            "assetLinks",
            "appleAppSiteAssociation",
        ]
        nullable_fields = [
            "placeholder",
            "expiredUrl",
            "notFoundUrl",
            "assetLinks",
            "appleAppSiteAssociation",
            "logo",
            "registeredDomain",
        ]
        null_default_fields = ["assetLinks", "appleAppSiteAssociation"]

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
