"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.types import BaseModel, Nullable, OptionalNullable, UNSET_SENTINEL
from enum import Enum
import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict


class Type(str, Enum):
    DEFAULT = "default"
    MEGA = "mega"


class AccessLevel(str, Enum):
    r"""The access level of the folder within the workspace."""

    WRITE = "write"
    READ = "read"


class FolderSchemaTypedDict(TypedDict):
    id: str
    r"""The unique ID of the folder."""
    name: str
    r"""The name of the folder."""
    type: Type
    created_at: str
    r"""The date the folder was created."""
    updated_at: str
    r"""The date the folder was updated."""
    access_level: NotRequired[Nullable[AccessLevel]]
    r"""The access level of the folder within the workspace."""


class FolderSchema(BaseModel):
    id: str
    r"""The unique ID of the folder."""

    name: str
    r"""The name of the folder."""

    type: Type

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The date the folder was created."""

    updated_at: Annotated[str, pydantic.Field(alias="updatedAt")]
    r"""The date the folder was updated."""

    access_level: Annotated[
        OptionalNullable[AccessLevel], pydantic.Field(alias="accessLevel")
    ] = None
    r"""The access level of the folder within the workspace."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["accessLevel"]
        nullable_fields = ["accessLevel"]
        null_default_fields = ["accessLevel"]

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
