"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.models.errors import DubError
from dub.types import BaseModel
from enum import Enum
import httpx
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class ConflictCode(str, Enum):
    r"""A short code indicating the error code returned."""

    CONFLICT = "conflict"


class ConflictErrorTypedDict(TypedDict):
    code: ConflictCode
    r"""A short code indicating the error code returned."""
    message: str
    r"""A human readable explanation of what went wrong."""
    doc_url: NotRequired[str]
    r"""A link to our documentation with more details about this error code"""


class ConflictError(BaseModel):
    code: ConflictCode
    r"""A short code indicating the error code returned."""

    message: str
    r"""A human readable explanation of what went wrong."""

    doc_url: Optional[str] = None
    r"""A link to our documentation with more details about this error code"""


class ConflictData(BaseModel):
    error: ConflictError


class Conflict(DubError):
    r"""This response is sent when a request conflicts with the current state of the server."""

    data: ConflictData

    def __init__(
        self,
        data: ConflictData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        self.data = data
