"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.models.errors import DubError
from dub.types import BaseModel
from enum import Enum
import httpx
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class NotFoundCode(str, Enum):
    r"""A short code indicating the error code returned."""

    NOT_FOUND = "not_found"


class NotFoundErrorTypedDict(TypedDict):
    code: NotFoundCode
    r"""A short code indicating the error code returned."""
    message: str
    r"""A human readable explanation of what went wrong."""
    doc_url: NotRequired[str]
    r"""A link to our documentation with more details about this error code"""


class NotFoundError(BaseModel):
    code: NotFoundCode
    r"""A short code indicating the error code returned."""

    message: str
    r"""A human readable explanation of what went wrong."""

    doc_url: Optional[str] = None
    r"""A link to our documentation with more details about this error code"""


class NotFoundData(BaseModel):
    error: NotFoundError


class NotFound(DubError):
    r"""The server cannot find the requested resource."""

    data: NotFoundData

    def __init__(
        self,
        data: NotFoundData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        self.data = data
