"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.models.errors import DubError
from dub.types import BaseModel
from enum import Enum
import httpx
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class UnprocessableEntityCode(str, Enum):
    r"""A short code indicating the error code returned."""

    UNPROCESSABLE_ENTITY = "unprocessable_entity"


class UnprocessableEntityErrorTypedDict(TypedDict):
    code: UnprocessableEntityCode
    r"""A short code indicating the error code returned."""
    message: str
    r"""A human readable explanation of what went wrong."""
    doc_url: NotRequired[str]
    r"""A link to our documentation with more details about this error code"""


class UnprocessableEntityError(BaseModel):
    code: UnprocessableEntityCode
    r"""A short code indicating the error code returned."""

    message: str
    r"""A human readable explanation of what went wrong."""

    doc_url: Optional[str] = None
    r"""A link to our documentation with more details about this error code"""


class UnprocessableEntityData(BaseModel):
    error: UnprocessableEntityError


class UnprocessableEntity(DubError):
    r"""The request was well-formed but was unable to be followed due to semantic errors."""

    data: UnprocessableEntityData

    def __init__(
        self,
        data: UnprocessableEntityData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        self.data = data
