"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from enum import Enum
import pydantic
from pydantic import model_serializer
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class Country(str, Enum):
    r"""The partner's country of residence. Must be passed as a 2-letter ISO 3166-1 country code. Learn more: https://d.to/geo"""

    AF = "AF"
    AL = "AL"
    DZ = "DZ"
    AS = "AS"
    AD = "AD"
    AO = "AO"
    AI = "AI"
    AQ = "AQ"
    AG = "AG"
    AR = "AR"
    AM = "AM"
    AW = "AW"
    AU = "AU"
    AT = "AT"
    AZ = "AZ"
    BS = "BS"
    BH = "BH"
    BD = "BD"
    BB = "BB"
    BY = "BY"
    BE = "BE"
    BZ = "BZ"
    BJ = "BJ"
    BM = "BM"
    BT = "BT"
    BO = "BO"
    BA = "BA"
    BW = "BW"
    BV = "BV"
    BR = "BR"
    IO = "IO"
    BN = "BN"
    BG = "BG"
    BF = "BF"
    BI = "BI"
    KH = "KH"
    CM = "CM"
    CA = "CA"
    CV = "CV"
    KY = "KY"
    CF = "CF"
    TD = "TD"
    CL = "CL"
    CN = "CN"
    CX = "CX"
    CC = "CC"
    CO = "CO"
    KM = "KM"
    CG = "CG"
    CD = "CD"
    CK = "CK"
    CR = "CR"
    CI = "CI"
    HR = "HR"
    CU = "CU"
    CY = "CY"
    CZ = "CZ"
    DK = "DK"
    DJ = "DJ"
    DM = "DM"
    DO = "DO"
    EC = "EC"
    EG = "EG"
    SV = "SV"
    GQ = "GQ"
    ER = "ER"
    EE = "EE"
    ET = "ET"
    FK = "FK"
    FO = "FO"
    FJ = "FJ"
    FI = "FI"
    FR = "FR"
    GF = "GF"
    PF = "PF"
    TF = "TF"
    GA = "GA"
    GM = "GM"
    GE = "GE"
    DE = "DE"
    GH = "GH"
    GI = "GI"
    GR = "GR"
    GL = "GL"
    GD = "GD"
    GP = "GP"
    GU = "GU"
    GT = "GT"
    GN = "GN"
    GW = "GW"
    GY = "GY"
    HT = "HT"
    HM = "HM"
    VA = "VA"
    HN = "HN"
    HK = "HK"
    HU = "HU"
    IS = "IS"
    IN = "IN"
    ID = "ID"
    IR = "IR"
    IQ = "IQ"
    IE = "IE"
    IL = "IL"
    IT = "IT"
    JM = "JM"
    JP = "JP"
    JO = "JO"
    KZ = "KZ"
    KE = "KE"
    KI = "KI"
    KP = "KP"
    KR = "KR"
    KW = "KW"
    KG = "KG"
    LA = "LA"
    LV = "LV"
    LB = "LB"
    LS = "LS"
    LR = "LR"
    LY = "LY"
    LI = "LI"
    LT = "LT"
    LU = "LU"
    MO = "MO"
    MG = "MG"
    MW = "MW"
    MY = "MY"
    MV = "MV"
    ML = "ML"
    MT = "MT"
    MH = "MH"
    MQ = "MQ"
    MR = "MR"
    MU = "MU"
    YT = "YT"
    MX = "MX"
    FM = "FM"
    MD = "MD"
    MC = "MC"
    MN = "MN"
    MS = "MS"
    MA = "MA"
    MZ = "MZ"
    MM = "MM"
    NA = "NA"
    NR = "NR"
    NP = "NP"
    NL = "NL"
    NC = "NC"
    NZ = "NZ"
    NI = "NI"
    NE = "NE"
    NG = "NG"
    NU = "NU"
    NF = "NF"
    MK = "MK"
    MP = "MP"
    NO = "NO"
    OM = "OM"
    PK = "PK"
    PW = "PW"
    PS = "PS"
    PA = "PA"
    PG = "PG"
    PY = "PY"
    PE = "PE"
    PH = "PH"
    PN = "PN"
    PL = "PL"
    PT = "PT"
    PR = "PR"
    QA = "QA"
    RE = "RE"
    RO = "RO"
    RU = "RU"
    RW = "RW"
    SH = "SH"
    KN = "KN"
    LC = "LC"
    PM = "PM"
    VC = "VC"
    WS = "WS"
    SM = "SM"
    ST = "ST"
    SA = "SA"
    SN = "SN"
    SC = "SC"
    SL = "SL"
    SG = "SG"
    SK = "SK"
    SI = "SI"
    SB = "SB"
    SO = "SO"
    ZA = "ZA"
    GS = "GS"
    ES = "ES"
    LK = "LK"
    SD = "SD"
    SR = "SR"
    SJ = "SJ"
    SZ = "SZ"
    SE = "SE"
    CH = "CH"
    SY = "SY"
    TW = "TW"
    TJ = "TJ"
    TZ = "TZ"
    TH = "TH"
    TL = "TL"
    TG = "TG"
    TK = "TK"
    TO = "TO"
    TT = "TT"
    TN = "TN"
    TR = "TR"
    TM = "TM"
    TC = "TC"
    TV = "TV"
    UG = "UG"
    UA = "UA"
    AE = "AE"
    GB = "GB"
    US = "US"
    UM = "UM"
    UY = "UY"
    UZ = "UZ"
    VU = "VU"
    VE = "VE"
    VN = "VN"
    VG = "VG"
    VI = "VI"
    WF = "WF"
    EH = "EH"
    YE = "YE"
    ZM = "ZM"
    ZW = "ZW"
    AX = "AX"
    BQ = "BQ"
    CW = "CW"
    GG = "GG"
    IM = "IM"
    JE = "JE"
    ME = "ME"
    BL = "BL"
    MF = "MF"
    RS = "RS"
    SX = "SX"
    SS = "SS"
    XK = "XK"


CreatePartnerTagIdsTypedDict = TypeAliasType(
    "CreatePartnerTagIdsTypedDict", Union[str, List[str]]
)
r"""The unique IDs of the tags assigned to the short link."""


CreatePartnerTagIds = TypeAliasType("CreatePartnerTagIds", Union[str, List[str]])
r"""The unique IDs of the tags assigned to the short link."""


CreatePartnerTagNamesTypedDict = TypeAliasType(
    "CreatePartnerTagNamesTypedDict", Union[str, List[str]]
)
r"""The unique name of the tags assigned to the short link (case insensitive)."""


CreatePartnerTagNames = TypeAliasType("CreatePartnerTagNames", Union[str, List[str]])
r"""The unique name of the tags assigned to the short link (case insensitive)."""


class CreatePartnerTestVariantsTypedDict(TypedDict):
    url: str
    percentage: float


class CreatePartnerTestVariants(BaseModel):
    url: str

    percentage: float


class LinkPropsTypedDict(TypedDict):
    r"""Additional properties that you can pass to the partner's short link. Will be used to override the default link properties for this partner."""

    key_length: NotRequired[float]
    r"""The length of the short link slug. Defaults to 7 if not provided. When used with `prefix`, the total length of the key will be `prefix.length + keyLength`."""
    external_id: NotRequired[Nullable[str]]
    r"""The ID of the link in your database. If set, it can be used to identify the link in future API requests (must be prefixed with 'ext_' when passed as a query parameter). This key is unique across your workspace."""
    tenant_id: NotRequired[Nullable[str]]
    r"""The ID of the tenant that created the link inside your system. If set, it can be used to fetch all links for a tenant."""
    prefix: NotRequired[str]
    r"""The prefix of the short link slug for randomly-generated keys (e.g. if prefix is `/c/`, generated keys will be in the `/c/:key` format). Will be ignored if `key` is provided."""
    archived: NotRequired[bool]
    r"""Whether the short link is archived. Defaults to `false` if not provided."""
    tag_ids: NotRequired[CreatePartnerTagIdsTypedDict]
    r"""The unique IDs of the tags assigned to the short link."""
    tag_names: NotRequired[CreatePartnerTagNamesTypedDict]
    r"""The unique name of the tags assigned to the short link (case insensitive)."""
    folder_id: NotRequired[Nullable[str]]
    r"""The unique ID existing folder to assign the short link to."""
    comments: NotRequired[Nullable[str]]
    r"""The comments for the short link."""
    expires_at: NotRequired[Nullable[str]]
    r"""The date and time when the short link will expire at."""
    expired_url: NotRequired[Nullable[str]]
    r"""The URL to redirect to when the short link has expired."""
    password: NotRequired[Nullable[str]]
    r"""The password required to access the destination URL of the short link."""
    proxy: NotRequired[bool]
    r"""Whether the short link uses Custom Link Previews feature. Defaults to `false` if not provided."""
    title: NotRequired[Nullable[str]]
    r"""The custom link preview title (og:title). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""
    description: NotRequired[Nullable[str]]
    r"""The custom link preview description (og:description). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""
    image: NotRequired[Nullable[str]]
    r"""The custom link preview image (og:image). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""
    video: NotRequired[Nullable[str]]
    r"""The custom link preview video (og:video). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""
    rewrite: NotRequired[bool]
    r"""Whether the short link uses link cloaking. Defaults to `false` if not provided."""
    ios: NotRequired[Nullable[str]]
    r"""The iOS destination URL for the short link for iOS device targeting."""
    android: NotRequired[Nullable[str]]
    r"""The Android destination URL for the short link for Android device targeting."""
    do_index: NotRequired[bool]
    r"""Allow search engines to index your short link. Defaults to `false` if not provided. Learn more: https://d.to/noindex"""
    utm_source: NotRequired[Nullable[str]]
    r"""The UTM source of the short link. If set, this will populate or override the UTM source in the destination URL."""
    utm_medium: NotRequired[Nullable[str]]
    r"""The UTM medium of the short link. If set, this will populate or override the UTM medium in the destination URL."""
    utm_campaign: NotRequired[Nullable[str]]
    r"""The UTM campaign of the short link. If set, this will populate or override the UTM campaign in the destination URL."""
    utm_term: NotRequired[Nullable[str]]
    r"""The UTM term of the short link. If set, this will populate or override the UTM term in the destination URL."""
    utm_content: NotRequired[Nullable[str]]
    r"""The UTM content of the short link. If set, this will populate or override the UTM content in the destination URL."""
    ref: NotRequired[Nullable[str]]
    r"""The referral tag of the short link. If set, this will populate or override the `ref` query parameter in the destination URL."""
    test_variants: NotRequired[Nullable[List[CreatePartnerTestVariantsTypedDict]]]
    r"""An array of A/B test URLs and the percentage of traffic to send to each URL."""
    test_started_at: NotRequired[Nullable[str]]
    r"""The date and time when the tests started."""
    test_completed_at: NotRequired[Nullable[str]]
    r"""The date and time when the tests were or will be completed."""


class LinkProps(BaseModel):
    r"""Additional properties that you can pass to the partner's short link. Will be used to override the default link properties for this partner."""

    key_length: Annotated[Optional[float], pydantic.Field(alias="keyLength")] = None
    r"""The length of the short link slug. Defaults to 7 if not provided. When used with `prefix`, the total length of the key will be `prefix.length + keyLength`."""

    external_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="externalId")
    ] = UNSET
    r"""The ID of the link in your database. If set, it can be used to identify the link in future API requests (must be prefixed with 'ext_' when passed as a query parameter). This key is unique across your workspace."""

    tenant_id: Annotated[OptionalNullable[str], pydantic.Field(alias="tenantId")] = (
        UNSET
    )
    r"""The ID of the tenant that created the link inside your system. If set, it can be used to fetch all links for a tenant."""

    prefix: Optional[str] = None
    r"""The prefix of the short link slug for randomly-generated keys (e.g. if prefix is `/c/`, generated keys will be in the `/c/:key` format). Will be ignored if `key` is provided."""

    archived: Optional[bool] = None
    r"""Whether the short link is archived. Defaults to `false` if not provided."""

    tag_ids: Annotated[
        Optional[CreatePartnerTagIds], pydantic.Field(alias="tagIds")
    ] = None
    r"""The unique IDs of the tags assigned to the short link."""

    tag_names: Annotated[
        Optional[CreatePartnerTagNames], pydantic.Field(alias="tagNames")
    ] = None
    r"""The unique name of the tags assigned to the short link (case insensitive)."""

    folder_id: Annotated[OptionalNullable[str], pydantic.Field(alias="folderId")] = (
        UNSET
    )
    r"""The unique ID existing folder to assign the short link to."""

    comments: OptionalNullable[str] = UNSET
    r"""The comments for the short link."""

    expires_at: Annotated[OptionalNullable[str], pydantic.Field(alias="expiresAt")] = (
        UNSET
    )
    r"""The date and time when the short link will expire at."""

    expired_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="expiredUrl")
    ] = UNSET
    r"""The URL to redirect to when the short link has expired."""

    password: OptionalNullable[str] = UNSET
    r"""The password required to access the destination URL of the short link."""

    proxy: Optional[bool] = None
    r"""Whether the short link uses Custom Link Previews feature. Defaults to `false` if not provided."""

    title: OptionalNullable[str] = UNSET
    r"""The custom link preview title (og:title). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""

    description: OptionalNullable[str] = UNSET
    r"""The custom link preview description (og:description). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""

    image: OptionalNullable[str] = UNSET
    r"""The custom link preview image (og:image). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""

    video: OptionalNullable[str] = UNSET
    r"""The custom link preview video (og:video). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""

    rewrite: Optional[bool] = None
    r"""Whether the short link uses link cloaking. Defaults to `false` if not provided."""

    ios: OptionalNullable[str] = UNSET
    r"""The iOS destination URL for the short link for iOS device targeting."""

    android: OptionalNullable[str] = UNSET
    r"""The Android destination URL for the short link for Android device targeting."""

    do_index: Annotated[Optional[bool], pydantic.Field(alias="doIndex")] = None
    r"""Allow search engines to index your short link. Defaults to `false` if not provided. Learn more: https://d.to/noindex"""

    utm_source: OptionalNullable[str] = UNSET
    r"""The UTM source of the short link. If set, this will populate or override the UTM source in the destination URL."""

    utm_medium: OptionalNullable[str] = UNSET
    r"""The UTM medium of the short link. If set, this will populate or override the UTM medium in the destination URL."""

    utm_campaign: OptionalNullable[str] = UNSET
    r"""The UTM campaign of the short link. If set, this will populate or override the UTM campaign in the destination URL."""

    utm_term: OptionalNullable[str] = UNSET
    r"""The UTM term of the short link. If set, this will populate or override the UTM term in the destination URL."""

    utm_content: OptionalNullable[str] = UNSET
    r"""The UTM content of the short link. If set, this will populate or override the UTM content in the destination URL."""

    ref: OptionalNullable[str] = UNSET
    r"""The referral tag of the short link. If set, this will populate or override the `ref` query parameter in the destination URL."""

    test_variants: Annotated[
        OptionalNullable[List[CreatePartnerTestVariants]],
        pydantic.Field(alias="testVariants"),
    ] = UNSET
    r"""An array of A/B test URLs and the percentage of traffic to send to each URL."""

    test_started_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="testStartedAt")
    ] = UNSET
    r"""The date and time when the tests started."""

    test_completed_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="testCompletedAt")
    ] = UNSET
    r"""The date and time when the tests were or will be completed."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "keyLength",
            "externalId",
            "tenantId",
            "prefix",
            "archived",
            "tagIds",
            "tagNames",
            "folderId",
            "comments",
            "expiresAt",
            "expiredUrl",
            "password",
            "proxy",
            "title",
            "description",
            "image",
            "video",
            "rewrite",
            "ios",
            "android",
            "doIndex",
            "utm_source",
            "utm_medium",
            "utm_campaign",
            "utm_term",
            "utm_content",
            "ref",
            "testVariants",
            "testStartedAt",
            "testCompletedAt",
        ]
        nullable_fields = [
            "externalId",
            "tenantId",
            "folderId",
            "comments",
            "expiresAt",
            "expiredUrl",
            "password",
            "title",
            "description",
            "image",
            "video",
            "ios",
            "android",
            "utm_source",
            "utm_medium",
            "utm_campaign",
            "utm_term",
            "utm_content",
            "ref",
            "testVariants",
            "testStartedAt",
            "testCompletedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreatePartnerRequestBodyTypedDict(TypedDict):
    email: str
    r"""The partner's email address. Partners will be able to claim their profile by signing up at `partners.dub.co` with this email."""
    name: NotRequired[Nullable[str]]
    r"""The partner's full name. If undefined, the partner's email will be used in lieu of their name (e.g. `john@acme.com`)"""
    username: NotRequired[Nullable[str]]
    r"""The partner's unique username in your system (max 100 characters). This will be used to create a short link for the partner using your program's default domain. If not provided, Dub will try to generate a username from the partner's name or email."""
    image: NotRequired[Nullable[str]]
    r"""The partner's avatar image. If not provided, a default avatar will be used."""
    tenant_id: NotRequired[str]
    r"""The partner's unique ID in your system. Useful for retrieving the partner's links and stats later on. If not provided, the partner will be created as a standalone partner."""
    country: NotRequired[Nullable[Country]]
    r"""The partner's country of residence. Must be passed as a 2-letter ISO 3166-1 country code. Learn more: https://d.to/geo"""
    description: NotRequired[Nullable[str]]
    r"""A brief description of the partner and their background. Max 5,000 characters."""
    link_props: NotRequired[LinkPropsTypedDict]
    r"""Additional properties that you can pass to the partner's short link. Will be used to override the default link properties for this partner."""


class CreatePartnerRequestBody(BaseModel):
    email: str
    r"""The partner's email address. Partners will be able to claim their profile by signing up at `partners.dub.co` with this email."""

    name: OptionalNullable[str] = UNSET
    r"""The partner's full name. If undefined, the partner's email will be used in lieu of their name (e.g. `john@acme.com`)"""

    username: OptionalNullable[str] = UNSET
    r"""The partner's unique username in your system (max 100 characters). This will be used to create a short link for the partner using your program's default domain. If not provided, Dub will try to generate a username from the partner's name or email."""

    image: OptionalNullable[str] = UNSET
    r"""The partner's avatar image. If not provided, a default avatar will be used."""

    tenant_id: Annotated[Optional[str], pydantic.Field(alias="tenantId")] = None
    r"""The partner's unique ID in your system. Useful for retrieving the partner's links and stats later on. If not provided, the partner will be created as a standalone partner."""

    country: OptionalNullable[Country] = UNSET
    r"""The partner's country of residence. Must be passed as a 2-letter ISO 3166-1 country code. Learn more: https://d.to/geo"""

    description: OptionalNullable[str] = UNSET
    r"""A brief description of the partner and their background. Max 5,000 characters."""

    link_props: Annotated[Optional[LinkProps], pydantic.Field(alias="linkProps")] = None
    r"""Additional properties that you can pass to the partner's short link. Will be used to override the default link properties for this partner."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "name",
            "username",
            "image",
            "tenantId",
            "country",
            "description",
            "linkProps",
        ]
        nullable_fields = ["name", "username", "image", "country", "description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreatePartnerStatus(str, Enum):
    r"""The status of the partner's enrollment in the program."""

    PENDING = "pending"
    APPROVED = "approved"
    REJECTED = "rejected"
    INVITED = "invited"
    DECLINED = "declined"
    BANNED = "banned"
    ARCHIVED = "archived"


class CreatePartnerLinkTypedDict(TypedDict):
    id: str
    r"""The unique ID of the short link."""
    domain: str
    r"""The domain of the short link. If not provided, the primary domain for the workspace will be used (or `dub.sh` if the workspace has no domains)."""
    key: str
    r"""The short link slug. If not provided, a random 7-character slug will be generated."""
    short_link: str
    r"""The full URL of the short link, including the https protocol (e.g. `https://dub.sh/try`)."""
    url: str
    r"""The destination URL of the short link."""
    clicks: NotRequired[float]
    r"""The number of clicks on the short link."""
    leads: NotRequired[float]
    r"""The number of leads the short link has generated."""
    sales: NotRequired[float]
    r"""The total number of sales (includes recurring sales) generated by the short link."""
    sale_amount: NotRequired[float]
    r"""The total dollar value of sales (in cents) generated by the short link."""


class CreatePartnerLink(BaseModel):
    id: str
    r"""The unique ID of the short link."""

    domain: str
    r"""The domain of the short link. If not provided, the primary domain for the workspace will be used (or `dub.sh` if the workspace has no domains)."""

    key: str
    r"""The short link slug. If not provided, a random 7-character slug will be generated."""

    short_link: Annotated[str, pydantic.Field(alias="shortLink")]
    r"""The full URL of the short link, including the https protocol (e.g. `https://dub.sh/try`)."""

    url: str
    r"""The destination URL of the short link."""

    clicks: Optional[float] = 0
    r"""The number of clicks on the short link."""

    leads: Optional[float] = 0
    r"""The number of leads the short link has generated."""

    sales: Optional[float] = 0
    r"""The total number of sales (includes recurring sales) generated by the short link."""

    sale_amount: Annotated[Optional[float], pydantic.Field(alias="saleAmount")] = 0
    r"""The total dollar value of sales (in cents) generated by the short link."""


class BannedReason(str, Enum):
    r"""If the partner was banned from the program, this is the reason for the ban."""

    TOS_VIOLATION = "tos_violation"
    INAPPROPRIATE_CONTENT = "inappropriate_content"
    FAKE_TRAFFIC = "fake_traffic"
    FRAUD = "fraud"
    SPAM = "spam"
    BRAND_ABUSE = "brand_abuse"


class CreatePartnerResponseBodyTypedDict(TypedDict):
    r"""The created partner"""

    id: str
    r"""The partner's unique ID on Dub."""
    name: str
    r"""The partner's full legal name."""
    email: Nullable[str]
    r"""The partner's email address. Should be a unique value across Dub."""
    image: Nullable[str]
    r"""The partner's avatar image."""
    country: Nullable[str]
    r"""The partner's country (required for tax purposes)."""
    paypal_email: Nullable[str]
    r"""The partner's PayPal email (for receiving payouts via PayPal)."""
    stripe_connect_id: Nullable[str]
    r"""The partner's Stripe Connect ID (for receiving payouts via Stripe)."""
    payouts_enabled_at: Nullable[str]
    r"""The date when the partner enabled payouts."""
    partner_id: str
    r"""The partner's unique ID on Dub."""
    tenant_id: Nullable[str]
    r"""The partner's unique ID within your database. Can be useful for associating the partner with a user in your database and retrieving/update their data in the future."""
    program_id: str
    r"""The program's unique ID on Dub."""
    created_at: str
    status: CreatePartnerStatus
    r"""The status of the partner's enrollment in the program."""
    links: Nullable[List[CreatePartnerLinkTypedDict]]
    r"""The partner's referral links in this program."""
    description: NotRequired[Nullable[str]]
    r"""A brief description of the partner and their background."""
    total_commissions: NotRequired[float]
    r"""The total commissions paid to the partner for their referrals. Defaults to 0 if `includeExpandedFields` is false."""
    click_reward_id: NotRequired[Nullable[str]]
    lead_reward_id: NotRequired[Nullable[str]]
    sale_reward_id: NotRequired[Nullable[str]]
    discount_id: NotRequired[Nullable[str]]
    application_id: NotRequired[Nullable[str]]
    r"""If the partner submitted an application to join the program, this is the ID of the application."""
    banned_at: NotRequired[Nullable[str]]
    r"""If the partner was banned from the program, this is the date of the ban."""
    banned_reason: NotRequired[Nullable[BannedReason]]
    r"""If the partner was banned from the program, this is the reason for the ban."""
    clicks: NotRequired[float]
    r"""The total number of clicks on the partner's links. Defaults to 0 if `includeExpandedFields` is false."""
    leads: NotRequired[float]
    r"""The total number of leads generated by the partner's links. Defaults to 0 if `includeExpandedFields` is false."""
    sales: NotRequired[float]
    r"""The total number of sales generated by the partner's links. Defaults to 0 if `includeExpandedFields` is false."""
    sale_amount: NotRequired[float]
    r"""The total amount of sales (in cents) generated by the partner's links. Defaults to 0 if `includeExpandedFields` is false."""
    net_revenue: NotRequired[float]
    r"""The total net revenue generated by the partner. Defaults to 0 if `includeExpandedFields` is false."""
    website: NotRequired[Nullable[str]]
    r"""The partner's website URL (including the https protocol)."""
    website_txt_record: NotRequired[Nullable[str]]
    website_verified_at: NotRequired[Nullable[str]]
    youtube: NotRequired[Nullable[str]]
    r"""The partner's YouTube channel username (e.g. `johndoe`)."""
    youtube_verified_at: NotRequired[Nullable[str]]
    youtube_subscriber_count: NotRequired[Nullable[float]]
    youtube_view_count: NotRequired[Nullable[float]]
    twitter: NotRequired[Nullable[str]]
    r"""The partner's Twitter username (e.g. `johndoe`)."""
    twitter_verified_at: NotRequired[Nullable[str]]
    linkedin: NotRequired[Nullable[str]]
    r"""The partner's LinkedIn username (e.g. `johndoe`)."""
    linkedin_verified_at: NotRequired[Nullable[str]]
    instagram: NotRequired[Nullable[str]]
    r"""The partner's Instagram username (e.g. `johndoe`)."""
    instagram_verified_at: NotRequired[Nullable[str]]
    tiktok: NotRequired[Nullable[str]]
    r"""The partner's TikTok username (e.g. `johndoe`)."""
    tiktok_verified_at: NotRequired[Nullable[str]]


class CreatePartnerResponseBody(BaseModel):
    r"""The created partner"""

    id: str
    r"""The partner's unique ID on Dub."""

    name: str
    r"""The partner's full legal name."""

    email: Nullable[str]
    r"""The partner's email address. Should be a unique value across Dub."""

    image: Nullable[str]
    r"""The partner's avatar image."""

    country: Nullable[str]
    r"""The partner's country (required for tax purposes)."""

    paypal_email: Annotated[Nullable[str], pydantic.Field(alias="paypalEmail")]
    r"""The partner's PayPal email (for receiving payouts via PayPal)."""

    stripe_connect_id: Annotated[Nullable[str], pydantic.Field(alias="stripeConnectId")]
    r"""The partner's Stripe Connect ID (for receiving payouts via Stripe)."""

    payouts_enabled_at: Annotated[
        Nullable[str], pydantic.Field(alias="payoutsEnabledAt")
    ]
    r"""The date when the partner enabled payouts."""

    partner_id: Annotated[str, pydantic.Field(alias="partnerId")]
    r"""The partner's unique ID on Dub."""

    tenant_id: Annotated[Nullable[str], pydantic.Field(alias="tenantId")]
    r"""The partner's unique ID within your database. Can be useful for associating the partner with a user in your database and retrieving/update their data in the future."""

    program_id: Annotated[str, pydantic.Field(alias="programId")]
    r"""The program's unique ID on Dub."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]

    status: CreatePartnerStatus
    r"""The status of the partner's enrollment in the program."""

    links: Nullable[List[CreatePartnerLink]]
    r"""The partner's referral links in this program."""

    description: OptionalNullable[str] = UNSET
    r"""A brief description of the partner and their background."""

    total_commissions: Annotated[
        Optional[float], pydantic.Field(alias="totalCommissions")
    ] = 0
    r"""The total commissions paid to the partner for their referrals. Defaults to 0 if `includeExpandedFields` is false."""

    click_reward_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="clickRewardId")
    ] = UNSET

    lead_reward_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="leadRewardId")
    ] = UNSET

    sale_reward_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="saleRewardId")
    ] = UNSET

    discount_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="discountId")
    ] = UNSET

    application_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="applicationId")
    ] = UNSET
    r"""If the partner submitted an application to join the program, this is the ID of the application."""

    banned_at: Annotated[OptionalNullable[str], pydantic.Field(alias="bannedAt")] = (
        UNSET
    )
    r"""If the partner was banned from the program, this is the date of the ban."""

    banned_reason: Annotated[
        OptionalNullable[BannedReason], pydantic.Field(alias="bannedReason")
    ] = UNSET
    r"""If the partner was banned from the program, this is the reason for the ban."""

    clicks: Optional[float] = 0
    r"""The total number of clicks on the partner's links. Defaults to 0 if `includeExpandedFields` is false."""

    leads: Optional[float] = 0
    r"""The total number of leads generated by the partner's links. Defaults to 0 if `includeExpandedFields` is false."""

    sales: Optional[float] = 0
    r"""The total number of sales generated by the partner's links. Defaults to 0 if `includeExpandedFields` is false."""

    sale_amount: Annotated[Optional[float], pydantic.Field(alias="saleAmount")] = 0
    r"""The total amount of sales (in cents) generated by the partner's links. Defaults to 0 if `includeExpandedFields` is false."""

    net_revenue: Annotated[Optional[float], pydantic.Field(alias="netRevenue")] = 0
    r"""The total net revenue generated by the partner. Defaults to 0 if `includeExpandedFields` is false."""

    website: OptionalNullable[str] = UNSET
    r"""The partner's website URL (including the https protocol)."""

    website_txt_record: Annotated[
        OptionalNullable[str], pydantic.Field(alias="websiteTxtRecord")
    ] = UNSET

    website_verified_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="websiteVerifiedAt")
    ] = UNSET

    youtube: OptionalNullable[str] = UNSET
    r"""The partner's YouTube channel username (e.g. `johndoe`)."""

    youtube_verified_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="youtubeVerifiedAt")
    ] = UNSET

    youtube_subscriber_count: Annotated[
        OptionalNullable[float], pydantic.Field(alias="youtubeSubscriberCount")
    ] = UNSET

    youtube_view_count: Annotated[
        OptionalNullable[float], pydantic.Field(alias="youtubeViewCount")
    ] = UNSET

    twitter: OptionalNullable[str] = UNSET
    r"""The partner's Twitter username (e.g. `johndoe`)."""

    twitter_verified_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="twitterVerifiedAt")
    ] = UNSET

    linkedin: OptionalNullable[str] = UNSET
    r"""The partner's LinkedIn username (e.g. `johndoe`)."""

    linkedin_verified_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="linkedinVerifiedAt")
    ] = UNSET

    instagram: OptionalNullable[str] = UNSET
    r"""The partner's Instagram username (e.g. `johndoe`)."""

    instagram_verified_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="instagramVerifiedAt")
    ] = UNSET

    tiktok: OptionalNullable[str] = UNSET
    r"""The partner's TikTok username (e.g. `johndoe`)."""

    tiktok_verified_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="tiktokVerifiedAt")
    ] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "totalCommissions",
            "clickRewardId",
            "leadRewardId",
            "saleRewardId",
            "discountId",
            "applicationId",
            "bannedAt",
            "bannedReason",
            "clicks",
            "leads",
            "sales",
            "saleAmount",
            "netRevenue",
            "website",
            "websiteTxtRecord",
            "websiteVerifiedAt",
            "youtube",
            "youtubeVerifiedAt",
            "youtubeSubscriberCount",
            "youtubeViewCount",
            "twitter",
            "twitterVerifiedAt",
            "linkedin",
            "linkedinVerifiedAt",
            "instagram",
            "instagramVerifiedAt",
            "tiktok",
            "tiktokVerifiedAt",
        ]
        nullable_fields = [
            "email",
            "image",
            "description",
            "country",
            "paypalEmail",
            "stripeConnectId",
            "payoutsEnabledAt",
            "tenantId",
            "links",
            "clickRewardId",
            "leadRewardId",
            "saleRewardId",
            "discountId",
            "applicationId",
            "bannedAt",
            "bannedReason",
            "website",
            "websiteTxtRecord",
            "websiteVerifiedAt",
            "youtube",
            "youtubeVerifiedAt",
            "youtubeSubscriberCount",
            "youtubeViewCount",
            "twitter",
            "twitterVerifiedAt",
            "linkedin",
            "linkedinVerifiedAt",
            "instagram",
            "instagramVerifiedAt",
            "tiktok",
            "tiktokVerifiedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
