"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from enum import Enum
import pydantic
from pydantic import model_serializer
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class CreateReferralsEmbedTokenCountry(str, Enum):
    r"""The partner's country of residence. Must be passed as a 2-letter ISO 3166-1 country code. Learn more: https://d.to/geo"""

    AF = "AF"
    AL = "AL"
    DZ = "DZ"
    AS = "AS"
    AD = "AD"
    AO = "AO"
    AI = "AI"
    AQ = "AQ"
    AG = "AG"
    AR = "AR"
    AM = "AM"
    AW = "AW"
    AU = "AU"
    AT = "AT"
    AZ = "AZ"
    BS = "BS"
    BH = "BH"
    BD = "BD"
    BB = "BB"
    BY = "BY"
    BE = "BE"
    BZ = "BZ"
    BJ = "BJ"
    BM = "BM"
    BT = "BT"
    BO = "BO"
    BA = "BA"
    BW = "BW"
    BV = "BV"
    BR = "BR"
    IO = "IO"
    BN = "BN"
    BG = "BG"
    BF = "BF"
    BI = "BI"
    KH = "KH"
    CM = "CM"
    CA = "CA"
    CV = "CV"
    KY = "KY"
    CF = "CF"
    TD = "TD"
    CL = "CL"
    CN = "CN"
    CX = "CX"
    CC = "CC"
    CO = "CO"
    KM = "KM"
    CG = "CG"
    CD = "CD"
    CK = "CK"
    CR = "CR"
    CI = "CI"
    HR = "HR"
    CU = "CU"
    CY = "CY"
    CZ = "CZ"
    DK = "DK"
    DJ = "DJ"
    DM = "DM"
    DO = "DO"
    EC = "EC"
    EG = "EG"
    SV = "SV"
    GQ = "GQ"
    ER = "ER"
    EE = "EE"
    ET = "ET"
    FK = "FK"
    FO = "FO"
    FJ = "FJ"
    FI = "FI"
    FR = "FR"
    GF = "GF"
    PF = "PF"
    TF = "TF"
    GA = "GA"
    GM = "GM"
    GE = "GE"
    DE = "DE"
    GH = "GH"
    GI = "GI"
    GR = "GR"
    GL = "GL"
    GD = "GD"
    GP = "GP"
    GU = "GU"
    GT = "GT"
    GN = "GN"
    GW = "GW"
    GY = "GY"
    HT = "HT"
    HM = "HM"
    VA = "VA"
    HN = "HN"
    HK = "HK"
    HU = "HU"
    IS = "IS"
    IN = "IN"
    ID = "ID"
    IR = "IR"
    IQ = "IQ"
    IE = "IE"
    IL = "IL"
    IT = "IT"
    JM = "JM"
    JP = "JP"
    JO = "JO"
    KZ = "KZ"
    KE = "KE"
    KI = "KI"
    KP = "KP"
    KR = "KR"
    KW = "KW"
    KG = "KG"
    LA = "LA"
    LV = "LV"
    LB = "LB"
    LS = "LS"
    LR = "LR"
    LY = "LY"
    LI = "LI"
    LT = "LT"
    LU = "LU"
    MO = "MO"
    MG = "MG"
    MW = "MW"
    MY = "MY"
    MV = "MV"
    ML = "ML"
    MT = "MT"
    MH = "MH"
    MQ = "MQ"
    MR = "MR"
    MU = "MU"
    YT = "YT"
    MX = "MX"
    FM = "FM"
    MD = "MD"
    MC = "MC"
    MN = "MN"
    MS = "MS"
    MA = "MA"
    MZ = "MZ"
    MM = "MM"
    NA = "NA"
    NR = "NR"
    NP = "NP"
    NL = "NL"
    NC = "NC"
    NZ = "NZ"
    NI = "NI"
    NE = "NE"
    NG = "NG"
    NU = "NU"
    NF = "NF"
    MK = "MK"
    MP = "MP"
    NO = "NO"
    OM = "OM"
    PK = "PK"
    PW = "PW"
    PS = "PS"
    PA = "PA"
    PG = "PG"
    PY = "PY"
    PE = "PE"
    PH = "PH"
    PN = "PN"
    PL = "PL"
    PT = "PT"
    PR = "PR"
    QA = "QA"
    RE = "RE"
    RO = "RO"
    RU = "RU"
    RW = "RW"
    SH = "SH"
    KN = "KN"
    LC = "LC"
    PM = "PM"
    VC = "VC"
    WS = "WS"
    SM = "SM"
    ST = "ST"
    SA = "SA"
    SN = "SN"
    SC = "SC"
    SL = "SL"
    SG = "SG"
    SK = "SK"
    SI = "SI"
    SB = "SB"
    SO = "SO"
    ZA = "ZA"
    GS = "GS"
    ES = "ES"
    LK = "LK"
    SD = "SD"
    SR = "SR"
    SJ = "SJ"
    SZ = "SZ"
    SE = "SE"
    CH = "CH"
    SY = "SY"
    TW = "TW"
    TJ = "TJ"
    TZ = "TZ"
    TH = "TH"
    TL = "TL"
    TG = "TG"
    TK = "TK"
    TO = "TO"
    TT = "TT"
    TN = "TN"
    TR = "TR"
    TM = "TM"
    TC = "TC"
    TV = "TV"
    UG = "UG"
    UA = "UA"
    AE = "AE"
    GB = "GB"
    US = "US"
    UM = "UM"
    UY = "UY"
    UZ = "UZ"
    VU = "VU"
    VE = "VE"
    VN = "VN"
    VG = "VG"
    VI = "VI"
    WF = "WF"
    EH = "EH"
    YE = "YE"
    ZM = "ZM"
    ZW = "ZW"
    AX = "AX"
    BQ = "BQ"
    CW = "CW"
    GG = "GG"
    IM = "IM"
    JE = "JE"
    ME = "ME"
    BL = "BL"
    MF = "MF"
    RS = "RS"
    SX = "SX"
    SS = "SS"
    XK = "XK"


CreateReferralsEmbedTokenTagIdsTypedDict = TypeAliasType(
    "CreateReferralsEmbedTokenTagIdsTypedDict", Union[str, List[str]]
)
r"""The unique IDs of the tags assigned to the short link."""


CreateReferralsEmbedTokenTagIds = TypeAliasType(
    "CreateReferralsEmbedTokenTagIds", Union[str, List[str]]
)
r"""The unique IDs of the tags assigned to the short link."""


CreateReferralsEmbedTokenTagNamesTypedDict = TypeAliasType(
    "CreateReferralsEmbedTokenTagNamesTypedDict", Union[str, List[str]]
)
r"""The unique name of the tags assigned to the short link (case insensitive)."""


CreateReferralsEmbedTokenTagNames = TypeAliasType(
    "CreateReferralsEmbedTokenTagNames", Union[str, List[str]]
)
r"""The unique name of the tags assigned to the short link (case insensitive)."""


class CreateReferralsEmbedTokenTestVariantsTypedDict(TypedDict):
    url: str
    percentage: float


class CreateReferralsEmbedTokenTestVariants(BaseModel):
    url: str

    percentage: float


class CreateReferralsEmbedTokenLinkPropsTypedDict(TypedDict):
    r"""Additional properties that you can pass to the partner's short link. Will be used to override the default link properties for this partner."""

    key_length: NotRequired[float]
    r"""The length of the short link slug. Defaults to 7 if not provided. When used with `prefix`, the total length of the key will be `prefix.length + keyLength`."""
    external_id: NotRequired[Nullable[str]]
    r"""The ID of the link in your database. If set, it can be used to identify the link in future API requests (must be prefixed with 'ext_' when passed as a query parameter). This key is unique across your workspace."""
    tenant_id: NotRequired[Nullable[str]]
    r"""The ID of the tenant that created the link inside your system. If set, it can be used to fetch all links for a tenant."""
    prefix: NotRequired[str]
    r"""The prefix of the short link slug for randomly-generated keys (e.g. if prefix is `/c/`, generated keys will be in the `/c/:key` format). Will be ignored if `key` is provided."""
    archived: NotRequired[bool]
    r"""Whether the short link is archived. Defaults to `false` if not provided."""
    tag_ids: NotRequired[CreateReferralsEmbedTokenTagIdsTypedDict]
    r"""The unique IDs of the tags assigned to the short link."""
    tag_names: NotRequired[CreateReferralsEmbedTokenTagNamesTypedDict]
    r"""The unique name of the tags assigned to the short link (case insensitive)."""
    folder_id: NotRequired[Nullable[str]]
    r"""The unique ID existing folder to assign the short link to."""
    comments: NotRequired[Nullable[str]]
    r"""The comments for the short link."""
    expires_at: NotRequired[Nullable[str]]
    r"""The date and time when the short link will expire at."""
    expired_url: NotRequired[Nullable[str]]
    r"""The URL to redirect to when the short link has expired."""
    password: NotRequired[Nullable[str]]
    r"""The password required to access the destination URL of the short link."""
    proxy: NotRequired[bool]
    r"""Whether the short link uses Custom Link Previews feature. Defaults to `false` if not provided."""
    title: NotRequired[Nullable[str]]
    r"""The custom link preview title (og:title). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""
    description: NotRequired[Nullable[str]]
    r"""The custom link preview description (og:description). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""
    image: NotRequired[Nullable[str]]
    r"""The custom link preview image (og:image). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""
    video: NotRequired[Nullable[str]]
    r"""The custom link preview video (og:video). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""
    rewrite: NotRequired[bool]
    r"""Whether the short link uses link cloaking. Defaults to `false` if not provided."""
    ios: NotRequired[Nullable[str]]
    r"""The iOS destination URL for the short link for iOS device targeting."""
    android: NotRequired[Nullable[str]]
    r"""The Android destination URL for the short link for Android device targeting."""
    do_index: NotRequired[bool]
    r"""Allow search engines to index your short link. Defaults to `false` if not provided. Learn more: https://d.to/noindex"""
    utm_source: NotRequired[Nullable[str]]
    r"""The UTM source of the short link. If set, this will populate or override the UTM source in the destination URL."""
    utm_medium: NotRequired[Nullable[str]]
    r"""The UTM medium of the short link. If set, this will populate or override the UTM medium in the destination URL."""
    utm_campaign: NotRequired[Nullable[str]]
    r"""The UTM campaign of the short link. If set, this will populate or override the UTM campaign in the destination URL."""
    utm_term: NotRequired[Nullable[str]]
    r"""The UTM term of the short link. If set, this will populate or override the UTM term in the destination URL."""
    utm_content: NotRequired[Nullable[str]]
    r"""The UTM content of the short link. If set, this will populate or override the UTM content in the destination URL."""
    ref: NotRequired[Nullable[str]]
    r"""The referral tag of the short link. If set, this will populate or override the `ref` query parameter in the destination URL."""
    test_variants: NotRequired[
        Nullable[List[CreateReferralsEmbedTokenTestVariantsTypedDict]]
    ]
    r"""An array of A/B test URLs and the percentage of traffic to send to each URL."""
    test_started_at: NotRequired[Nullable[str]]
    r"""The date and time when the tests started."""
    test_completed_at: NotRequired[Nullable[str]]
    r"""The date and time when the tests were or will be completed."""


class CreateReferralsEmbedTokenLinkProps(BaseModel):
    r"""Additional properties that you can pass to the partner's short link. Will be used to override the default link properties for this partner."""

    key_length: Annotated[Optional[float], pydantic.Field(alias="keyLength")] = None
    r"""The length of the short link slug. Defaults to 7 if not provided. When used with `prefix`, the total length of the key will be `prefix.length + keyLength`."""

    external_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="externalId")
    ] = UNSET
    r"""The ID of the link in your database. If set, it can be used to identify the link in future API requests (must be prefixed with 'ext_' when passed as a query parameter). This key is unique across your workspace."""

    tenant_id: Annotated[OptionalNullable[str], pydantic.Field(alias="tenantId")] = (
        UNSET
    )
    r"""The ID of the tenant that created the link inside your system. If set, it can be used to fetch all links for a tenant."""

    prefix: Optional[str] = None
    r"""The prefix of the short link slug for randomly-generated keys (e.g. if prefix is `/c/`, generated keys will be in the `/c/:key` format). Will be ignored if `key` is provided."""

    archived: Optional[bool] = None
    r"""Whether the short link is archived. Defaults to `false` if not provided."""

    tag_ids: Annotated[
        Optional[CreateReferralsEmbedTokenTagIds], pydantic.Field(alias="tagIds")
    ] = None
    r"""The unique IDs of the tags assigned to the short link."""

    tag_names: Annotated[
        Optional[CreateReferralsEmbedTokenTagNames], pydantic.Field(alias="tagNames")
    ] = None
    r"""The unique name of the tags assigned to the short link (case insensitive)."""

    folder_id: Annotated[OptionalNullable[str], pydantic.Field(alias="folderId")] = (
        UNSET
    )
    r"""The unique ID existing folder to assign the short link to."""

    comments: OptionalNullable[str] = UNSET
    r"""The comments for the short link."""

    expires_at: Annotated[OptionalNullable[str], pydantic.Field(alias="expiresAt")] = (
        UNSET
    )
    r"""The date and time when the short link will expire at."""

    expired_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="expiredUrl")
    ] = UNSET
    r"""The URL to redirect to when the short link has expired."""

    password: OptionalNullable[str] = UNSET
    r"""The password required to access the destination URL of the short link."""

    proxy: Optional[bool] = None
    r"""Whether the short link uses Custom Link Previews feature. Defaults to `false` if not provided."""

    title: OptionalNullable[str] = UNSET
    r"""The custom link preview title (og:title). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""

    description: OptionalNullable[str] = UNSET
    r"""The custom link preview description (og:description). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""

    image: OptionalNullable[str] = UNSET
    r"""The custom link preview image (og:image). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""

    video: OptionalNullable[str] = UNSET
    r"""The custom link preview video (og:video). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""

    rewrite: Optional[bool] = None
    r"""Whether the short link uses link cloaking. Defaults to `false` if not provided."""

    ios: OptionalNullable[str] = UNSET
    r"""The iOS destination URL for the short link for iOS device targeting."""

    android: OptionalNullable[str] = UNSET
    r"""The Android destination URL for the short link for Android device targeting."""

    do_index: Annotated[Optional[bool], pydantic.Field(alias="doIndex")] = None
    r"""Allow search engines to index your short link. Defaults to `false` if not provided. Learn more: https://d.to/noindex"""

    utm_source: OptionalNullable[str] = UNSET
    r"""The UTM source of the short link. If set, this will populate or override the UTM source in the destination URL."""

    utm_medium: OptionalNullable[str] = UNSET
    r"""The UTM medium of the short link. If set, this will populate or override the UTM medium in the destination URL."""

    utm_campaign: OptionalNullable[str] = UNSET
    r"""The UTM campaign of the short link. If set, this will populate or override the UTM campaign in the destination URL."""

    utm_term: OptionalNullable[str] = UNSET
    r"""The UTM term of the short link. If set, this will populate or override the UTM term in the destination URL."""

    utm_content: OptionalNullable[str] = UNSET
    r"""The UTM content of the short link. If set, this will populate or override the UTM content in the destination URL."""

    ref: OptionalNullable[str] = UNSET
    r"""The referral tag of the short link. If set, this will populate or override the `ref` query parameter in the destination URL."""

    test_variants: Annotated[
        OptionalNullable[List[CreateReferralsEmbedTokenTestVariants]],
        pydantic.Field(alias="testVariants"),
    ] = UNSET
    r"""An array of A/B test URLs and the percentage of traffic to send to each URL."""

    test_started_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="testStartedAt")
    ] = UNSET
    r"""The date and time when the tests started."""

    test_completed_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="testCompletedAt")
    ] = UNSET
    r"""The date and time when the tests were or will be completed."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "keyLength",
            "externalId",
            "tenantId",
            "prefix",
            "archived",
            "tagIds",
            "tagNames",
            "folderId",
            "comments",
            "expiresAt",
            "expiredUrl",
            "password",
            "proxy",
            "title",
            "description",
            "image",
            "video",
            "rewrite",
            "ios",
            "android",
            "doIndex",
            "utm_source",
            "utm_medium",
            "utm_campaign",
            "utm_term",
            "utm_content",
            "ref",
            "testVariants",
            "testStartedAt",
            "testCompletedAt",
        ]
        nullable_fields = [
            "externalId",
            "tenantId",
            "folderId",
            "comments",
            "expiresAt",
            "expiredUrl",
            "password",
            "title",
            "description",
            "image",
            "video",
            "ios",
            "android",
            "utm_source",
            "utm_medium",
            "utm_campaign",
            "utm_term",
            "utm_content",
            "ref",
            "testVariants",
            "testStartedAt",
            "testCompletedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PartnerTypedDict(TypedDict):
    email: str
    r"""The partner's email address. Partners will be able to claim their profile by signing up at `partners.dub.co` with this email."""
    name: NotRequired[Nullable[str]]
    r"""The partner's full name. If undefined, the partner's email will be used in lieu of their name (e.g. `john@acme.com`)"""
    username: NotRequired[Nullable[str]]
    r"""The partner's unique username in your system (max 100 characters). This will be used to create a short link for the partner using your program's default domain. If not provided, Dub will try to generate a username from the partner's name or email."""
    image: NotRequired[Nullable[str]]
    r"""The partner's avatar image. If not provided, a default avatar will be used."""
    tenant_id: NotRequired[str]
    r"""The partner's unique ID in your system. Useful for retrieving the partner's links and stats later on. If not provided, the partner will be created as a standalone partner."""
    country: NotRequired[Nullable[CreateReferralsEmbedTokenCountry]]
    r"""The partner's country of residence. Must be passed as a 2-letter ISO 3166-1 country code. Learn more: https://d.to/geo"""
    description: NotRequired[Nullable[str]]
    r"""A brief description of the partner and their background. Max 5,000 characters."""
    link_props: NotRequired[CreateReferralsEmbedTokenLinkPropsTypedDict]
    r"""Additional properties that you can pass to the partner's short link. Will be used to override the default link properties for this partner."""


class Partner(BaseModel):
    email: str
    r"""The partner's email address. Partners will be able to claim their profile by signing up at `partners.dub.co` with this email."""

    name: OptionalNullable[str] = UNSET
    r"""The partner's full name. If undefined, the partner's email will be used in lieu of their name (e.g. `john@acme.com`)"""

    username: OptionalNullable[str] = UNSET
    r"""The partner's unique username in your system (max 100 characters). This will be used to create a short link for the partner using your program's default domain. If not provided, Dub will try to generate a username from the partner's name or email."""

    image: OptionalNullable[str] = UNSET
    r"""The partner's avatar image. If not provided, a default avatar will be used."""

    tenant_id: Annotated[Optional[str], pydantic.Field(alias="tenantId")] = None
    r"""The partner's unique ID in your system. Useful for retrieving the partner's links and stats later on. If not provided, the partner will be created as a standalone partner."""

    country: OptionalNullable[CreateReferralsEmbedTokenCountry] = UNSET
    r"""The partner's country of residence. Must be passed as a 2-letter ISO 3166-1 country code. Learn more: https://d.to/geo"""

    description: OptionalNullable[str] = UNSET
    r"""A brief description of the partner and their background. Max 5,000 characters."""

    link_props: Annotated[
        Optional[CreateReferralsEmbedTokenLinkProps], pydantic.Field(alias="linkProps")
    ] = None
    r"""Additional properties that you can pass to the partner's short link. Will be used to override the default link properties for this partner."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "name",
            "username",
            "image",
            "tenantId",
            "country",
            "description",
            "linkProps",
        ]
        nullable_fields = ["name", "username", "image", "country", "description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateReferralsEmbedTokenRequestBodyTypedDict(TypedDict):
    partner_id: NotRequired[str]
    tenant_id: NotRequired[str]
    partner: NotRequired[PartnerTypedDict]


class CreateReferralsEmbedTokenRequestBody(BaseModel):
    partner_id: Annotated[Optional[str], pydantic.Field(alias="partnerId")] = None

    tenant_id: Annotated[Optional[str], pydantic.Field(alias="tenantId")] = None

    partner: Optional[Partner] = None


class CreateReferralsEmbedTokenResponseBodyTypedDict(TypedDict):
    r"""The created public embed token."""

    public_token: str
    expires: str


class CreateReferralsEmbedTokenResponseBody(BaseModel):
    r"""The created public embed token."""

    public_token: Annotated[str, pydantic.Field(alias="publicToken")]

    expires: str
