"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.types import BaseModel
from dub.utils import FieldMetadata, QueryParamMetadata
from enum import Enum
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class Level(str, Enum):
    r"""The level of error correction to use for the QR code. Defaults to `L` if not provided."""

    L = "L"
    M = "M"
    Q = "Q"
    H = "H"


class GetQRCodeRequestTypedDict(TypedDict):
    url: str
    r"""The URL to generate a QR code for."""
    logo: NotRequired[str]
    r"""The logo to include in the QR code. Can only be used with a paid plan on Dub."""
    size: NotRequired[float]
    r"""The size of the QR code in pixels. Defaults to `600` if not provided."""
    level: NotRequired[Level]
    r"""The level of error correction to use for the QR code. Defaults to `L` if not provided."""
    fg_color: NotRequired[str]
    r"""The foreground color of the QR code in hex format. Defaults to `#000000` if not provided."""
    bg_color: NotRequired[str]
    r"""The background color of the QR code in hex format. Defaults to `#ffffff` if not provided."""
    hide_logo: NotRequired[bool]
    r"""Whether to hide the logo in the QR code. Can only be used with a paid plan on Dub."""
    margin: NotRequired[float]
    r"""The size of the margin around the QR code. Defaults to 2 if not provided."""
    include_margin: NotRequired[bool]
    r"""DEPRECATED: Margin is included by default. Use the `margin` prop to customize the margin size."""


class GetQRCodeRequest(BaseModel):
    url: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The URL to generate a QR code for."""

    logo: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The logo to include in the QR code. Can only be used with a paid plan on Dub."""

    size: Annotated[
        Optional[float],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 600
    r"""The size of the QR code in pixels. Defaults to `600` if not provided."""

    level: Annotated[
        Optional[Level],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = Level.L
    r"""The level of error correction to use for the QR code. Defaults to `L` if not provided."""

    fg_color: Annotated[
        Optional[str],
        pydantic.Field(alias="fgColor"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = "#000000"
    r"""The foreground color of the QR code in hex format. Defaults to `#000000` if not provided."""

    bg_color: Annotated[
        Optional[str],
        pydantic.Field(alias="bgColor"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = "#FFFFFF"
    r"""The background color of the QR code in hex format. Defaults to `#ffffff` if not provided."""

    hide_logo: Annotated[
        Optional[bool],
        pydantic.Field(alias="hideLogo"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = True
    r"""Whether to hide the logo in the QR code. Can only be used with a paid plan on Dub."""

    margin: Annotated[
        Optional[float],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 2
    r"""The size of the margin around the QR code. Defaults to 2 if not provided."""

    include_margin: Annotated[
        Optional[bool],
        pydantic.Field(alias="includeMargin"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = True
    r"""DEPRECATED: Margin is included by default. Use the `margin` prop to customize the margin size."""
