"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.types import BaseModel
from dub.utils import FieldMetadata, QueryParamMetadata
from enum import Enum
import pydantic
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class GetTagsQueryParamSortBy(str, Enum):
    r"""The field to sort the tags by."""

    NAME = "name"
    CREATED_AT = "createdAt"


class GetTagsQueryParamSortOrder(str, Enum):
    r"""The order to sort the tags by."""

    ASC = "asc"
    DESC = "desc"


IdsTypedDict = TypeAliasType("IdsTypedDict", Union[str, List[str]])
r"""IDs of tags to filter by."""


Ids = TypeAliasType("Ids", Union[str, List[str]])
r"""IDs of tags to filter by."""


class GetTagsRequestTypedDict(TypedDict):
    sort_by: NotRequired[GetTagsQueryParamSortBy]
    r"""The field to sort the tags by."""
    sort_order: NotRequired[GetTagsQueryParamSortOrder]
    r"""The order to sort the tags by."""
    search: NotRequired[str]
    r"""The search term to filter the tags by."""
    ids: NotRequired[IdsTypedDict]
    r"""IDs of tags to filter by."""
    page: NotRequired[float]
    r"""The page number for pagination."""
    page_size: NotRequired[float]
    r"""The number of items per page."""


class GetTagsRequest(BaseModel):
    sort_by: Annotated[
        Optional[GetTagsQueryParamSortBy],
        pydantic.Field(alias="sortBy"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = GetTagsQueryParamSortBy.NAME
    r"""The field to sort the tags by."""

    sort_order: Annotated[
        Optional[GetTagsQueryParamSortOrder],
        pydantic.Field(alias="sortOrder"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = GetTagsQueryParamSortOrder.ASC
    r"""The order to sort the tags by."""

    search: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The search term to filter the tags by."""

    ids: Annotated[
        Optional[Ids],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""IDs of tags to filter by."""

    page: Annotated[
        Optional[float],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""The page number for pagination."""

    page_size: Annotated[
        Optional[float],
        pydantic.Field(alias="pageSize"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 100
    r"""The number of items per page."""
