"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.models.components import (
    partneranalyticscount as components_partneranalyticscount,
    partneranalyticstimeseries as components_partneranalyticstimeseries,
    partneranalyticstoplinks as components_partneranalyticstoplinks,
)
from dub.types import BaseModel
from dub.utils import FieldMetadata, QueryParamMetadata
from enum import Enum
import pydantic
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class RetrievePartnerAnalyticsQueryParamInterval(str, Enum):
    r"""The interval to retrieve analytics for. If undefined, defaults to 24h."""

    TWENTY_FOURH = "24h"
    SEVEND = "7d"
    THIRTYD = "30d"
    NINETYD = "90d"
    ONEY = "1y"
    MTD = "mtd"
    QTD = "qtd"
    YTD = "ytd"
    ALL = "all"


class RetrievePartnerAnalyticsQueryParamGroupBy(str, Enum):
    r"""The parameter to group the analytics data points by. Defaults to `count` if undefined."""

    TOP_LINKS = "top_links"
    TIMESERIES = "timeseries"
    COUNT = "count"


class RetrievePartnerAnalyticsRequestTypedDict(TypedDict):
    partner_id: NotRequired[str]
    r"""The ID of the partner to retrieve analytics for."""
    tenant_id: NotRequired[str]
    r"""The ID of the tenant that created the link inside your system."""
    interval: NotRequired[RetrievePartnerAnalyticsQueryParamInterval]
    r"""The interval to retrieve analytics for. If undefined, defaults to 24h."""
    start: NotRequired[str]
    r"""The start date and time when to retrieve analytics from. If set, takes precedence over `interval`."""
    end: NotRequired[str]
    r"""The end date and time when to retrieve analytics from. If not provided, defaults to the current date. If set along with `start`, takes precedence over `interval`."""
    timezone: NotRequired[str]
    r"""The IANA time zone code for aligning timeseries granularity (e.g. America/New_York). Defaults to UTC."""
    group_by: NotRequired[RetrievePartnerAnalyticsQueryParamGroupBy]
    r"""The parameter to group the analytics data points by. Defaults to `count` if undefined."""


class RetrievePartnerAnalyticsRequest(BaseModel):
    partner_id: Annotated[
        Optional[str],
        pydantic.Field(alias="partnerId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The ID of the partner to retrieve analytics for."""

    tenant_id: Annotated[
        Optional[str],
        pydantic.Field(alias="tenantId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The ID of the tenant that created the link inside your system."""

    interval: Annotated[
        Optional[RetrievePartnerAnalyticsQueryParamInterval],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The interval to retrieve analytics for. If undefined, defaults to 24h."""

    start: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The start date and time when to retrieve analytics from. If set, takes precedence over `interval`."""

    end: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The end date and time when to retrieve analytics from. If not provided, defaults to the current date. If set along with `start`, takes precedence over `interval`."""

    timezone: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = "UTC"
    r"""The IANA time zone code for aligning timeseries granularity (e.g. America/New_York). Defaults to UTC."""

    group_by: Annotated[
        Optional[RetrievePartnerAnalyticsQueryParamGroupBy],
        pydantic.Field(alias="groupBy"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = RetrievePartnerAnalyticsQueryParamGroupBy.COUNT
    r"""The parameter to group the analytics data points by. Defaults to `count` if undefined."""


RetrievePartnerAnalyticsResponseBodyTypedDict = TypeAliasType(
    "RetrievePartnerAnalyticsResponseBodyTypedDict",
    Union[
        components_partneranalyticscount.PartnerAnalyticsCountTypedDict,
        List[components_partneranalyticstimeseries.PartnerAnalyticsTimeseriesTypedDict],
        List[components_partneranalyticstoplinks.PartnerAnalyticsTopLinksTypedDict],
    ],
)
r"""Partner analytics data"""


RetrievePartnerAnalyticsResponseBody = TypeAliasType(
    "RetrievePartnerAnalyticsResponseBody",
    Union[
        components_partneranalyticscount.PartnerAnalyticsCount,
        List[components_partneranalyticstimeseries.PartnerAnalyticsTimeseries],
        List[components_partneranalyticstoplinks.PartnerAnalyticsTopLinks],
    ],
)
r"""Partner analytics data"""
