"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from enum import Enum
import pydantic
from pydantic import model_serializer
from typing import Any, Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PaymentProcessor(str, Enum):
    r"""The payment processor via which the sale was made."""

    STRIPE = "stripe"
    SHOPIFY = "shopify"
    POLAR = "polar"
    PADDLE = "paddle"
    REVENUECAT = "revenuecat"
    CUSTOM = "custom"


class TrackSaleRequestBodyTypedDict(TypedDict):
    customer_external_id: str
    r"""The unique ID of the customer in your system. Will be used to identify and attribute all future events to this customer."""
    amount: int
    r"""The amount of the sale in cents (for all two-decimal currencies). If the sale is in a zero-decimal currency, pass the full integer value (e.g. `1437` JPY). Learn more: https://d.to/currency"""
    payment_processor: PaymentProcessor
    r"""The payment processor via which the sale was made."""
    currency: NotRequired[str]
    r"""The currency of the sale. Accepts ISO 4217 currency codes. Sales will be automatically converted and stored as USD at the latest exchange rates. Learn more: https://d.to/currency"""
    event_name: NotRequired[str]
    r"""The name of the sale event. Recommended format: `Invoice paid` or `Subscription created`."""
    invoice_id: NotRequired[Nullable[str]]
    r"""The invoice ID of the sale. Can be used as a idempotency key – only one sale event can be recorded for a given invoice ID."""
    lead_event_name: NotRequired[Nullable[str]]
    r"""The name of the lead event that occurred before the sale (case-sensitive). This is used to associate the sale event with a particular lead event (instead of the latest lead event for a link-customer combination, which is the default behavior)."""
    metadata: NotRequired[Nullable[Dict[str, Any]]]
    r"""Additional metadata to be stored with the sale event. Max 10,000 characters when stringified."""


class TrackSaleRequestBody(BaseModel):
    customer_external_id: Annotated[str, pydantic.Field(alias="customerExternalId")]
    r"""The unique ID of the customer in your system. Will be used to identify and attribute all future events to this customer."""

    amount: int
    r"""The amount of the sale in cents (for all two-decimal currencies). If the sale is in a zero-decimal currency, pass the full integer value (e.g. `1437` JPY). Learn more: https://d.to/currency"""

    payment_processor: Annotated[
        PaymentProcessor, pydantic.Field(alias="paymentProcessor")
    ]
    r"""The payment processor via which the sale was made."""

    currency: Optional[str] = "usd"
    r"""The currency of the sale. Accepts ISO 4217 currency codes. Sales will be automatically converted and stored as USD at the latest exchange rates. Learn more: https://d.to/currency"""

    event_name: Annotated[Optional[str], pydantic.Field(alias="eventName")] = "Purchase"
    r"""The name of the sale event. Recommended format: `Invoice paid` or `Subscription created`."""

    invoice_id: Annotated[OptionalNullable[str], pydantic.Field(alias="invoiceId")] = (
        None
    )
    r"""The invoice ID of the sale. Can be used as a idempotency key – only one sale event can be recorded for a given invoice ID."""

    lead_event_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="leadEventName")
    ] = None
    r"""The name of the lead event that occurred before the sale (case-sensitive). This is used to associate the sale event with a particular lead event (instead of the latest lead event for a link-customer combination, which is the default behavior)."""

    metadata: OptionalNullable[Dict[str, Any]] = UNSET
    r"""Additional metadata to be stored with the sale event. Max 10,000 characters when stringified."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "currency",
            "eventName",
            "invoiceId",
            "leadEventName",
            "metadata",
        ]
        nullable_fields = ["invoiceId", "leadEventName", "metadata"]
        null_default_fields = ["invoiceId", "leadEventName"]

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TrackSaleCustomerTypedDict(TypedDict):
    id: str
    name: Nullable[str]
    email: Nullable[str]
    avatar: Nullable[str]
    external_id: Nullable[str]


class TrackSaleCustomer(BaseModel):
    id: str

    name: Nullable[str]

    email: Nullable[str]

    avatar: Nullable[str]

    external_id: Annotated[Nullable[str], pydantic.Field(alias="externalId")]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["name", "email", "avatar", "externalId"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SaleTypedDict(TypedDict):
    amount: float
    currency: str
    payment_processor: str
    invoice_id: Nullable[str]
    metadata: Nullable[Dict[str, Any]]


class Sale(BaseModel):
    amount: float

    currency: str

    payment_processor: Annotated[str, pydantic.Field(alias="paymentProcessor")]

    invoice_id: Annotated[Nullable[str], pydantic.Field(alias="invoiceId")]

    metadata: Nullable[Dict[str, Any]]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["invoiceId", "metadata"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TrackSaleResponseBodyTypedDict(TypedDict):
    r"""A sale was tracked."""

    event_name: str
    customer: Nullable[TrackSaleCustomerTypedDict]
    sale: Nullable[SaleTypedDict]


class TrackSaleResponseBody(BaseModel):
    r"""A sale was tracked."""

    event_name: Annotated[str, pydantic.Field(alias="eventName")]

    customer: Nullable[TrackSaleCustomer]

    sale: Nullable[Sale]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["customer", "sale"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
