"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from dub.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)
from enum import Enum
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateCustomerRequestBodyTypedDict(TypedDict):
    email: NotRequired[Nullable[str]]
    r"""Email of the customer in the client's app."""
    name: NotRequired[Nullable[str]]
    r"""Name of the customer in the client's app. If not provided, a random name will be generated."""
    avatar: NotRequired[Nullable[str]]
    r"""Avatar URL of the customer in the client's app."""
    external_id: NotRequired[str]
    r"""Unique identifier for the customer in the client's app."""


class UpdateCustomerRequestBody(BaseModel):
    email: OptionalNullable[str] = UNSET
    r"""Email of the customer in the client's app."""

    name: OptionalNullable[str] = UNSET
    r"""Name of the customer in the client's app. If not provided, a random name will be generated."""

    avatar: OptionalNullable[str] = UNSET
    r"""Avatar URL of the customer in the client's app."""

    external_id: Annotated[Optional[str], pydantic.Field(alias="externalId")] = None
    r"""Unique identifier for the customer in the client's app."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["email", "name", "avatar", "externalId"]
        nullable_fields = ["email", "name", "avatar"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdateCustomerRequestTypedDict(TypedDict):
    id: str
    r"""The unique ID of the customer. You may use either the customer's `id` on Dub (obtained via `/customers` endpoint) or their `externalId` (unique ID within your system, prefixed with `ext_`, e.g. `ext_123`)."""
    include_expanded_fields: NotRequired[bool]
    r"""Whether to include expanded fields on the customer (`link`, `partner`, `discount`)."""
    request_body: NotRequired[UpdateCustomerRequestBodyTypedDict]


class UpdateCustomerRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The unique ID of the customer. You may use either the customer's `id` on Dub (obtained via `/customers` endpoint) or their `externalId` (unique ID within your system, prefixed with `ext_`, e.g. `ext_123`)."""

    include_expanded_fields: Annotated[
        Optional[bool],
        pydantic.Field(alias="includeExpandedFields"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Whether to include expanded fields on the customer (`link`, `partner`, `discount`)."""

    request_body: Annotated[
        Optional[UpdateCustomerRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class UpdateCustomerLinkTypedDict(TypedDict):
    id: str
    r"""The unique ID of the short link."""
    domain: str
    r"""The domain of the short link. If not provided, the primary domain for the workspace will be used (or `dub.sh` if the workspace has no domains)."""
    key: str
    r"""The short link slug. If not provided, a random 7-character slug will be generated."""
    short_link: str
    r"""The full URL of the short link, including the https protocol (e.g. `https://dub.sh/try`)."""
    url: str
    r"""The destination URL of the short link."""
    program_id: Nullable[str]
    r"""The ID of the program the short link is associated with."""


class UpdateCustomerLink(BaseModel):
    id: str
    r"""The unique ID of the short link."""

    domain: str
    r"""The domain of the short link. If not provided, the primary domain for the workspace will be used (or `dub.sh` if the workspace has no domains)."""

    key: str
    r"""The short link slug. If not provided, a random 7-character slug will be generated."""

    short_link: Annotated[str, pydantic.Field(alias="shortLink")]
    r"""The full URL of the short link, including the https protocol (e.g. `https://dub.sh/try`)."""

    url: str
    r"""The destination URL of the short link."""

    program_id: Annotated[Nullable[str], pydantic.Field(alias="programId")]
    r"""The ID of the program the short link is associated with."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["programId"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdateCustomerPartnerTypedDict(TypedDict):
    id: str
    r"""The partner's unique ID on Dub."""
    name: str
    r"""The partner's full legal name."""
    email: Nullable[str]
    r"""The partner's email address. Should be a unique value across Dub."""
    image: Nullable[str]
    r"""The partner's avatar image."""


class UpdateCustomerPartner(BaseModel):
    id: str
    r"""The partner's unique ID on Dub."""

    name: str
    r"""The partner's full legal name."""

    email: Nullable[str]
    r"""The partner's email address. Should be a unique value across Dub."""

    image: Nullable[str]
    r"""The partner's avatar image."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["email", "image"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdateCustomerType(str, Enum):
    PERCENTAGE = "percentage"
    FLAT = "flat"


class UpdateCustomerDiscountTypedDict(TypedDict):
    id: str
    amount: float
    type: UpdateCustomerType
    max_duration: Nullable[float]
    coupon_id: Nullable[str]
    coupon_test_id: Nullable[str]
    default: bool
    description: NotRequired[Nullable[str]]
    partners_count: NotRequired[Nullable[float]]


class UpdateCustomerDiscount(BaseModel):
    id: str

    amount: float

    type: UpdateCustomerType

    max_duration: Annotated[Nullable[float], pydantic.Field(alias="maxDuration")]

    coupon_id: Annotated[Nullable[str], pydantic.Field(alias="couponId")]

    coupon_test_id: Annotated[Nullable[str], pydantic.Field(alias="couponTestId")]

    default: bool

    description: OptionalNullable[str] = UNSET

    partners_count: Annotated[
        OptionalNullable[float], pydantic.Field(alias="partnersCount")
    ] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "partnersCount"]
        nullable_fields = [
            "maxDuration",
            "description",
            "couponId",
            "couponTestId",
            "partnersCount",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdateCustomerResponseBodyTypedDict(TypedDict):
    r"""The customer was updated."""

    id: str
    r"""The unique ID of the customer. You may use either the customer's `id` on Dub (obtained via `/customers` endpoint) or their `externalId` (unique ID within your system, prefixed with `ext_`, e.g. `ext_123`)."""
    external_id: str
    r"""Unique identifier for the customer in the client's app."""
    name: str
    r"""Name of the customer."""
    created_at: str
    r"""The date the customer was created."""
    email: NotRequired[Nullable[str]]
    r"""Email of the customer."""
    avatar: NotRequired[Nullable[str]]
    r"""Avatar URL of the customer."""
    country: NotRequired[Nullable[str]]
    r"""Country of the customer."""
    sales: NotRequired[Nullable[float]]
    r"""Total number of sales for the customer."""
    sale_amount: NotRequired[Nullable[float]]
    r"""Total amount of sales for the customer."""
    link: NotRequired[Nullable[UpdateCustomerLinkTypedDict]]
    program_id: NotRequired[Nullable[str]]
    partner: NotRequired[Nullable[UpdateCustomerPartnerTypedDict]]
    discount: NotRequired[Nullable[UpdateCustomerDiscountTypedDict]]


class UpdateCustomerResponseBody(BaseModel):
    r"""The customer was updated."""

    id: str
    r"""The unique ID of the customer. You may use either the customer's `id` on Dub (obtained via `/customers` endpoint) or their `externalId` (unique ID within your system, prefixed with `ext_`, e.g. `ext_123`)."""

    external_id: Annotated[str, pydantic.Field(alias="externalId")]
    r"""Unique identifier for the customer in the client's app."""

    name: str
    r"""Name of the customer."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The date the customer was created."""

    email: OptionalNullable[str] = UNSET
    r"""Email of the customer."""

    avatar: OptionalNullable[str] = UNSET
    r"""Avatar URL of the customer."""

    country: OptionalNullable[str] = UNSET
    r"""Country of the customer."""

    sales: OptionalNullable[float] = UNSET
    r"""Total number of sales for the customer."""

    sale_amount: Annotated[
        OptionalNullable[float], pydantic.Field(alias="saleAmount")
    ] = UNSET
    r"""Total amount of sales for the customer."""

    link: OptionalNullable[UpdateCustomerLink] = UNSET

    program_id: Annotated[OptionalNullable[str], pydantic.Field(alias="programId")] = (
        UNSET
    )

    partner: OptionalNullable[UpdateCustomerPartner] = UNSET

    discount: OptionalNullable[UpdateCustomerDiscount] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "email",
            "avatar",
            "country",
            "sales",
            "saleAmount",
            "link",
            "programId",
            "partner",
            "discount",
        ]
        nullable_fields = [
            "email",
            "avatar",
            "country",
            "sales",
            "saleAmount",
            "link",
            "programId",
            "partner",
            "discount",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
