"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from dub.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateWorkspaceRequestBodyTypedDict(TypedDict):
    name: NotRequired[str]
    slug: NotRequired[str]
    logo: NotRequired[Nullable[str]]
    conversion_enabled: NotRequired[bool]
    allowed_hostnames: NotRequired[List[str]]


class UpdateWorkspaceRequestBody(BaseModel):
    name: Optional[str] = None

    slug: Optional[str] = None

    logo: OptionalNullable[str] = UNSET

    conversion_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="conversionEnabled")
    ] = None

    allowed_hostnames: Annotated[
        Optional[List[str]], pydantic.Field(alias="allowedHostnames")
    ] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "name",
            "slug",
            "logo",
            "conversionEnabled",
            "allowedHostnames",
        ]
        nullable_fields = ["logo"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdateWorkspaceRequestTypedDict(TypedDict):
    id_or_slug: str
    r"""The ID or slug of the workspace to update."""
    request_body: NotRequired[UpdateWorkspaceRequestBodyTypedDict]


class UpdateWorkspaceRequest(BaseModel):
    id_or_slug: Annotated[
        str,
        pydantic.Field(alias="idOrSlug"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID or slug of the workspace to update."""

    request_body: Annotated[
        Optional[UpdateWorkspaceRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None
