#
# This source file is part of the EdgeDB open source project.
#
# Copyright 2016-present MagicStack Inc. and the EdgeDB authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#


# flake8: noqa

from ._version import __version__

from gel.datatypes.datatypes import (
    Tuple,
    NamedTuple,
    EnumValue,
    RelativeDuration,
    DateDuration,
    ConfigMemory,
)
from gel.datatypes.datatypes import Record, Set, Object, Array
from gel.datatypes.range import Range, MultiRange

from .abstract import (
    Executor,
    AsyncIOExecutor,
    ReadOnlyExecutor,
    AsyncIOReadOnlyExecutor,
    expr,
)
from .base_client import ConnectionInfo

from .asyncio_client import create_async_client, AsyncIOClient

from .blocking_client import create_client, Client
from .enums import Cardinality, ElementKind
from .options import RetryCondition, IsolationLevel, default_backoff
from .options import RetryOptions, TransactionOptions
from .options import State

from .errors._base import EdgeDBError, EdgeDBMessage

__all__ = [
    "Array",
    "AsyncIOClient",
    "AsyncIOExecutor",
    "AsyncIOReadOnlyExecutor",
    "Cardinality",
    "Client",
    "ConfigMemory",
    "ConnectionInfo",
    "DateDuration",
    "EdgeDBError",
    "EdgeDBMessage",
    "ElementKind",
    "EnumValue",
    "Executor",
    "IsolationLevel",
    "MultiRange",
    "NamedTuple",
    "Object",
    "Range",
    "ReadOnlyExecutor",
    "RelativeDuration",
    "RetryCondition",
    "RetryOptions",
    "Set",
    "Record",
    "State",
    "TransactionOptions",
    "Tuple",
    "create_async_client",
    "create_client",
    "default_backoff",
    "expr",
]


# The below is generated by `make gen-errors`.
# DO NOT MODIFY BY HAND.
#
# <ERRORS-AUTOGEN>
from .errors import (
    AccessError,
    AccessPolicyError,
    AuthenticationError,
    AvailabilityError,
    BackendError,
    BackendUnavailableError,
    BinaryProtocolError,
    CapabilityError,
    CardinalityViolationError,
    ClientConnectionClosedError,
    ClientConnectionError,
    ClientConnectionFailedError,
    ClientConnectionFailedTemporarilyError,
    ClientConnectionTimeoutError,
    ClientError,
    ConfigurationError,
    ConstraintViolationError,
    DeprecatedScopingError,
    DisabledCapabilityError,
    DivisionByZeroError,
    DuplicateCastDefinitionError,
    DuplicateConstraintDefinitionError,
    DuplicateDatabaseDefinitionError,
    DuplicateDefinitionError,
    DuplicateFunctionDefinitionError,
    DuplicateLinkDefinitionError,
    DuplicateMigrationError,
    DuplicateModuleDefinitionError,
    DuplicateOperatorDefinitionError,
    DuplicatePropertyDefinitionError,
    DuplicateUserDefinitionError,
    DuplicateViewDefinitionError,
    EdgeQLSyntaxError,
    ExecutionError,
    GraphQLSyntaxError,
    IdleSessionTimeoutError,
    IdleTransactionTimeoutError,
    InputDataError,
    IntegrityError,
    InterfaceError,
    InternalClientError,
    InternalServerError,
    InvalidAliasDefinitionError,
    InvalidArgumentError,
    InvalidCastDefinitionError,
    InvalidConstraintDefinitionError,
    InvalidDatabaseDefinitionError,
    InvalidDefinitionError,
    InvalidFunctionDefinitionError,
    InvalidLinkDefinitionError,
    InvalidLinkTargetError,
    InvalidModuleDefinitionError,
    InvalidOperatorDefinitionError,
    InvalidPropertyDefinitionError,
    InvalidPropertyTargetError,
    InvalidReferenceError,
    InvalidSyntaxError,
    InvalidTargetError,
    InvalidTypeError,
    InvalidUserDefinitionError,
    InvalidValueError,
    LogMessage,
    MigrationStatusMessage,
    MissingArgumentError,
    MissingRequiredError,
    NoDataError,
    NumericOutOfRangeError,
    ParameterTypeMismatchError,
    ProtocolError,
    QueryArgumentError,
    QueryAssertionError,
    QueryCacheInvalidationError,
    QueryError,
    QueryTimeoutError,
    ResultCardinalityMismatchError,
    SchemaDefinitionError,
    SchemaError,
    SchemaSyntaxError,
    ServerBlockedError,
    ServerOfflineError,
    SessionTimeoutError,
    StateMismatchError,
    StatusMessage,
    TransactionConflictError,
    TransactionDeadlockError,
    TransactionError,
    TransactionSerializationError,
    TransactionTimeoutError,
    TypeSpecNotFoundError,
    UnexpectedMessageError,
    UnknownArgumentError,
    UnknownDatabaseError,
    UnknownLinkError,
    UnknownModuleError,
    UnknownParameterError,
    UnknownPropertyError,
    UnknownTenantError,
    UnknownUserError,
    UnsafeIsolationLevelError,
    UnsupportedBackendFeatureError,
    UnsupportedCapabilityError,
    UnsupportedFeatureError,
    UnsupportedProtocolVersionError,
    WarningMessage,
    WatchError,
)

__all__.extend(
    [
        "AccessError",
        "AccessPolicyError",
        "AuthenticationError",
        "AvailabilityError",
        "BackendError",
        "BackendUnavailableError",
        "BinaryProtocolError",
        "CapabilityError",
        "CardinalityViolationError",
        "ClientConnectionClosedError",
        "ClientConnectionError",
        "ClientConnectionFailedError",
        "ClientConnectionFailedTemporarilyError",
        "ClientConnectionTimeoutError",
        "ClientError",
        "ConfigurationError",
        "ConstraintViolationError",
        "DeprecatedScopingError",
        "DisabledCapabilityError",
        "DivisionByZeroError",
        "DuplicateCastDefinitionError",
        "DuplicateConstraintDefinitionError",
        "DuplicateDatabaseDefinitionError",
        "DuplicateDefinitionError",
        "DuplicateFunctionDefinitionError",
        "DuplicateLinkDefinitionError",
        "DuplicateMigrationError",
        "DuplicateModuleDefinitionError",
        "DuplicateOperatorDefinitionError",
        "DuplicatePropertyDefinitionError",
        "DuplicateUserDefinitionError",
        "DuplicateViewDefinitionError",
        "EdgeQLSyntaxError",
        "ExecutionError",
        "GraphQLSyntaxError",
        "IdleSessionTimeoutError",
        "IdleTransactionTimeoutError",
        "InputDataError",
        "IntegrityError",
        "InterfaceError",
        "InternalClientError",
        "InternalServerError",
        "InvalidAliasDefinitionError",
        "InvalidArgumentError",
        "InvalidCastDefinitionError",
        "InvalidConstraintDefinitionError",
        "InvalidDatabaseDefinitionError",
        "InvalidDefinitionError",
        "InvalidFunctionDefinitionError",
        "InvalidLinkDefinitionError",
        "InvalidLinkTargetError",
        "InvalidModuleDefinitionError",
        "InvalidOperatorDefinitionError",
        "InvalidPropertyDefinitionError",
        "InvalidPropertyTargetError",
        "InvalidReferenceError",
        "InvalidSyntaxError",
        "InvalidTargetError",
        "InvalidTypeError",
        "InvalidUserDefinitionError",
        "InvalidValueError",
        "LogMessage",
        "MigrationStatusMessage",
        "MissingArgumentError",
        "MissingRequiredError",
        "NoDataError",
        "NumericOutOfRangeError",
        "ParameterTypeMismatchError",
        "ProtocolError",
        "QueryArgumentError",
        "QueryAssertionError",
        "QueryCacheInvalidationError",
        "QueryError",
        "QueryTimeoutError",
        "ResultCardinalityMismatchError",
        "SchemaDefinitionError",
        "SchemaError",
        "SchemaSyntaxError",
        "ServerBlockedError",
        "ServerOfflineError",
        "SessionTimeoutError",
        "StateMismatchError",
        "StatusMessage",
        "TransactionConflictError",
        "TransactionDeadlockError",
        "TransactionError",
        "TransactionSerializationError",
        "TransactionTimeoutError",
        "TypeSpecNotFoundError",
        "UnexpectedMessageError",
        "UnknownArgumentError",
        "UnknownDatabaseError",
        "UnknownLinkError",
        "UnknownModuleError",
        "UnknownParameterError",
        "UnknownPropertyError",
        "UnknownTenantError",
        "UnknownUserError",
        "UnsafeIsolationLevelError",
        "UnsupportedBackendFeatureError",
        "UnsupportedCapabilityError",
        "UnsupportedFeatureError",
        "UnsupportedProtocolVersionError",
        "WarningMessage",
        "WatchError",
    ]
)
# </ERRORS-AUTOGEN>
