# SPDX-PackageName: gel-python
# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Copyright Gel Data Inc. and the contributors.


UNRESERVED_KEYWORDS: frozenset[str] = frozenset(
    {
        "abort",
        "abstract",
        "access",
        "after",
        "alias",
        "all",
        "allow",
        "annotation",
        "applied",
        "as",
        "asc",
        "assignment",
        "before",
        "blobal",
        "branch",
        "cardinality",
        "cast",
        "committed",
        "config",
        "conflict",
        "constraint",
        "cube",
        "current",
        "data",
        "database",
        "ddl",
        "declare",
        "default",
        "deferrable",
        "deferred",
        "delegated",
        "deny",
        "desc",
        "each",
        "empty",
        "except",
        "expression",
        "extension",
        "final",
        "first",
        "force",
        "from",
        "function",
        "future",
        "implicit",
        "index",
        "infix",
        "inheritable",
        "instance",
        "intersect",
        "into",
        "isolation",
        "json",
        "last",
        "link",
        "migration",
        "multi",
        "named",
        "object",
        "of",
        "only",
        "onto",
        "operator",
        "optionality",
        "order",
        "orphan",
        "overloaded",
        "owned",
        "package",
        "policy",
        "populate",
        "postfix",
        "prefix",
        "property",
        "proposed",
        "pseudo",
        "read",
        "reject",
        "release",
        "rename",
        "repeatable",
        "required",
        "reset",
        "restrict",
        "rewrite",
        "role",
        "roles",
        "rollup",
        "savepoint",
        "scalar",
        "schema",
        "sdl",
        "serializable",
        "session",
        "source",
        "superuser",
        "system",
        "target",
        "template",
        "ternary",
        "text",
        "then",
        "to",
        "transaction",
        "trigger",
        "type",
        "union",
        "unless",
        "using",
        "verbose",
        "version",
        "view",
        "write",
    }
)

FUTURE_RESERVED_KEYWORDS: frozenset[str] = frozenset(
    {
        "anyarray",
        "begin",
        "case",
        "check",
        "deallocate",
        "discard",
        "end",
        "explain",
        "fetch",
        "get",
        "grant",
        "import",
        "listen",
        "load",
        "lock",
        "match",
        "move",
        "notify",
        "on",
        "over",
        "prepare",
        "partition",
        "raise",
        "refresh",
        "revoke",
        "when",
        "window",
        "never",
    }
)

CURRENT_RESERVED_KEYWORDS: frozenset[str] = frozenset(
    {
        "__source__",
        "__subject__",
        "__type__",
        "__std__",
        "__edgedbsys__",
        "__edgedbtpl__",
        "__new__",
        "__old__",
        "__specified__",
        "__default__",
        "administer",
        "alter",
        "analyze",
        "and",
        "anytuple",
        "anytype",
        "anyobject",
        "by",
        "commit",
        "configure",
        "create",
        "delete",
        "describe",
        "detached",
        "distinct",
        "do",
        "drop",
        "else",
        "exists",
        "extending",
        "false",
        "filter",
        "for",
        "global",
        "group",
        "if",
        "ilike",
        "in",
        "insert",
        "introspect",
        "is",
        "like",
        "limit",
        "module",
        "not",
        "offset",
        "optional",
        "or",
        "rollback",
        "select",
        "set",
        "single",
        "start",
        "true",
        "typeof",
        "update",
        "variadic",
        "with",
    }
)

RESERVED_KEYWRORDS = CURRENT_RESERVED_KEYWORDS | FUTURE_RESERVED_KEYWORDS

COMBINED_KEYWORDS: frozenset[str] = frozenset(
    {
        "named only",
        "set annotation",
        "set type",
        "extension package",
        "order by",
    }
)

ALL_KEYWORDS = UNRESERVED_KEYWORDS | RESERVED_KEYWRORDS | COMBINED_KEYWORDS
