# SPDX-PackageName: gel-python
# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Copyright Gel Data Inc. and the contributors.

"""EdgeQL Query Builder"""

from __future__ import annotations

from ._abstract import (
    AbstractDescriptor,
    AbstractFieldDescriptor,
    Expr,
    PathPrefix,
    Scope,
    ScopeContext,
    Stmt,
)

from ._expressions import (
    BinaryOp,
    BoolLiteral,
    BytesLiteral,
    CastOp,
    DecimalLiteral,
    DeleteStmt,
    Direction,
    EmptyDirection,
    ExprPlaceholder,
    Filter,
    FloatLiteral,
    ForStmt,
    FuncCall,
    Global,
    IndexOp,
    InfixOp,
    IntLiteral,
    Limit,
    Literal,
    Offset,
    OrderBy,
    OrderByElem,
    OrderByExpr,
    OrderDirection,
    OrderEmptyDirection,
    Path,
    PrefixOp,
    SchemaSet,
    SelectStmt,
    SetLiteral,
    Shape,
    ShapeElement,
    ShapeOp,
    Splat,
    StringLiteral,
    UpdateStmt,
    Variable,
    empty_set,
    empty_set_if_none,
    get_object_type_splat,
    toplevel_edgeql,
)

from ._generics import (
    AnnotatedGlobal,
    AnnotatedExpr,
    AnnotatedPath,
    AnnotatedVar,
    BaseAlias,
    ExprAlias,
    GlobalAlias,
    PathAlias,
    SortAlias,
    VarAlias,
    is_pointer_descriptor,
)

from ._protocols import (
    ExprClosure,
    ExprCompatible,
    edgeql_qb_expr,
    edgeql,
    exprmethod,
    is_expr_compatible,
)

from ._reflection import (
    GelLinkMetadata,
    GelPointerReflection,
    GelReflectionProto,
    GelSchemaMetadata,
    GelSourceMetadata,
    GelTypeMetadata,
    GelObjectTypeMetadata,
)


__all__ = (
    "AbstractDescriptor",
    "AbstractFieldDescriptor",
    "AnnotatedExpr",
    "AnnotatedGlobal",
    "AnnotatedPath",
    "AnnotatedVar",
    "BaseAlias",
    "BinaryOp",
    "BoolLiteral",
    "BytesLiteral",
    "CastOp",
    "DecimalLiteral",
    "DeleteStmt",
    "Direction",
    "EmptyDirection",
    "Expr",
    "ExprAlias",
    "ExprClosure",
    "ExprCompatible",
    "ExprPlaceholder",
    "Filter",
    "FloatLiteral",
    "ForStmt",
    "FuncCall",
    "GelLinkMetadata",
    "GelObjectTypeMetadata",
    "GelPointerReflection",
    "GelReflectionProto",
    "GelSchemaMetadata",
    "GelSourceMetadata",
    "GelTypeMetadata",
    "Global",
    "GlobalAlias",
    "IndexOp",
    "InfixOp",
    "IntLiteral",
    "Limit",
    "Literal",
    "Offset",
    "OrderBy",
    "OrderByElem",
    "OrderByExpr",
    "OrderDirection",
    "OrderEmptyDirection",
    "Path",
    "PathAlias",
    "PathPrefix",
    "PrefixOp",
    "SchemaSet",
    "Scope",
    "ScopeContext",
    "SelectStmt",
    "SetLiteral",
    "Shape",
    "ShapeElement",
    "ShapeOp",
    "SortAlias",
    "Splat",
    "Stmt",
    "StringLiteral",
    "UpdateStmt",
    "VarAlias",
    "Variable",
    "edgeql",
    "edgeql_qb_expr",
    "empty_set",
    "empty_set_if_none",
    "exprmethod",
    "get_object_type_splat",
    "is_expr_compatible",
    "is_pointer_descriptor",
    "toplevel_edgeql",
)
