# SPDX-PackageName: gel-python
# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Copyright Gel Data Inc. and the contributors.

from ._base import (
    SchemaObject,
)

from ._enums import (
    CallableParamKind,
    Cardinality,
    OperatorKind,
    PointerKind,
    SchemaPart,
    TypeKind,
    TypeModifier,
)

from ._casts import (
    CastMatrix,
    fetch_casts,
)

from ._callables import (
    Callable,
    CallableParam,
    CallableParamGetter,
    CallableParamKey,
    CallableParamTypeMap,
    CallableSignature,
    compare_callable_generality,
)

from ._functions import (
    Function,
    fetch_functions,
)

from ._globals import (
    Global,
    fetch_globals,
)

from ._operators import (
    Operator,
    OperatorMatrix,
    fetch_operators,
)

from ._state import (
    BranchState,
    ServerVersion,
    fetch_branch_state,
)

from ._types import (
    ArrayType,
    CollectionType,
    HeterogeneousCollectionType,
    HomogeneousCollectionType,
    InheritingType,
    NamedTupleType,
    ObjectType,
    Pointer,
    PrimitiveType,
    PseudoType,
    ScalarType,
    TupleType,
    Type,
    compare_type_generality,
    fetch_types,
    is_abstract_type,
    is_array_type,
    is_link,
    is_multi_range_type,
    is_named_tuple_type,
    is_non_enum_scalar_type,
    is_object_type,
    is_primitive_type,
    is_property,
    is_pseudo_type,
    is_range_type,
    is_scalar_type,
    is_tuple_type,
)

from ._modules import (
    fetch_modules,
)

__all__ = (
    "ArrayType",
    "BranchState",
    "Callable",
    "CallableParam",
    "CallableParamGetter",
    "CallableParamKey",
    "CallableParamKind",
    "CallableParamTypeMap",
    "CallableSignature",
    "Cardinality",
    "CastMatrix",
    "CollectionType",
    "Function",
    "Global",
    "HeterogeneousCollectionType",
    "HomogeneousCollectionType",
    "InheritingType",
    "NamedTupleType",
    "ObjectType",
    "Operator",
    "OperatorKind",
    "OperatorMatrix",
    "Pointer",
    "PointerKind",
    "PrimitiveType",
    "PseudoType",
    "ScalarType",
    "SchemaObject",
    "SchemaPart",
    "ServerVersion",
    "TupleType",
    "Type",
    "TypeKind",
    "TypeModifier",
    "compare_callable_generality",
    "compare_type_generality",
    "fetch_branch_state",
    "fetch_casts",
    "fetch_functions",
    "fetch_globals",
    "fetch_modules",
    "fetch_operators",
    "fetch_types",
    "is_abstract_type",
    "is_array_type",
    "is_link",
    "is_multi_range_type",
    "is_named_tuple_type",
    "is_non_enum_scalar_type",
    "is_object_type",
    "is_primitive_type",
    "is_property",
    "is_pseudo_type",
    "is_range_type",
    "is_scalar_type",
    "is_tuple_type",
)
