# SPDX-PackageName: gel-python
# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Copyright Gel Data Inc. and the contributors.


"""API exported to generated Pydantic-based models."""

from pydantic import (
    PrivateAttr,
    computed_field,
)

from gel._internal._deferred_import import DeferredImport
from gel._internal._edgeql import Cardinality, PointerKind
from gel._internal._lazyprop import LazyClassProperty
from gel._internal._schemapath import SchemaPath
from gel._internal._typing_dispatch import dispatch_overload
from gel._internal._utils import UnspecifiedType, Unspecified
from gel._internal._xmethod import classonlymethod

from gel._internal._qb import (
    AnnotatedExpr,
    BaseAlias,
    EmptyDirection,
    Direction,
    GelLinkMetadata,
    GelObjectTypeMetadata,
    GelPointerReflection,
    GelSchemaMetadata,
    GelTypeMetadata,
    ExprClosure,
    ExprCompatible,
    IndexOp,
    InfixOp,
    PrefixOp,
    FuncCall,
    PathAlias,
)

from gel._internal._qbmodel._abstract import (
    DEFAULT_VALUE,
    AnyEnum,
    AnyNamedTuple,
    AnyTuple,
    DateImpl,
    DateTimeImpl,
    DateTimeLike,
    DefaultValue,
    GelLinkModelDescriptor,
    GelScalarType,
    GelType,
    GelTypeMeta,
    Global,
    JSONImpl,
    TimeDeltaImpl,
    TimeImpl,
    PyConstType,
    PyTypeScalarConstraint,
    UUIDImpl,
    empty_set_if_none,
)

from gel._internal._qbmodel._pydantic import (
    Array,
    GelLinkModel,
    GelModel,
    GelModelMeta,
    IdProperty,
    LinkClassNamespace,
    ComputedLinkWithProps,
    ComputedMultiLink,
    ComputedMultiLinkWithProps,
    ComputedMultiProperty,
    ComputedProperty,
    ComputedLink,
    RequiredMultiLink,
    RequiredMultiLinkWithProps,
    MultiProperty,
    MultiRange,
    OptionalLink,
    OptionalLinkWithProps,
    OptionalMultiLink,
    OptionalMultiLinkWithProps,
    OptionalProperty,
    OptionalComputedLink,
    OptionalComputedLinkWithProps,
    OptionalComputedProperty,
    ProxyModel,
    Property,
    RequiredLink,
    RequiredLinkWithProps,
    PyTypeScalar,
    Range,
    Tuple,
)

__all__ = (
    "DEFAULT_VALUE",
    "AnnotatedExpr",
    "AnyEnum",
    "AnyNamedTuple",
    "AnyTuple",
    "Array",
    "BaseAlias",
    "Cardinality",
    "ComputedLink",
    "ComputedLinkWithProps",
    "ComputedMultiLink",
    "ComputedMultiLinkWithProps",
    "ComputedMultiProperty",
    "ComputedProperty",
    "DateImpl",
    "DateTimeImpl",
    "DateTimeLike",
    "DefaultValue",
    "DeferredImport",
    "Direction",
    "EmptyDirection",
    "ExprClosure",
    "ExprCompatible",
    "FuncCall",
    "GelLinkMetadata",
    "GelLinkModel",
    "GelLinkModelDescriptor",
    "GelModel",
    "GelModelMeta",
    "GelObjectTypeMetadata",
    "GelPointerReflection",
    "GelScalarType",
    "GelSchemaMetadata",
    "GelType",
    "GelTypeMeta",
    "GelTypeMetadata",
    "Global",
    "IdProperty",
    "IndexOp",
    "InfixOp",
    "JSONImpl",
    "LazyClassProperty",
    "LinkClassNamespace",
    "MultiProperty",
    "MultiRange",
    "OptionalComputedLink",
    "OptionalComputedLinkWithProps",
    "OptionalComputedProperty",
    "OptionalLink",
    "OptionalLinkWithProps",
    "OptionalMultiLink",
    "OptionalMultiLinkWithProps",
    "OptionalProperty",
    "PathAlias",
    "PointerKind",
    "PrefixOp",
    "PrivateAttr",
    "Property",
    "ProxyModel",
    "PyConstType",
    "PyTypeScalar",
    "PyTypeScalarConstraint",
    "Range",
    "RequiredLink",
    "RequiredLinkWithProps",
    "RequiredMultiLink",
    "RequiredMultiLinkWithProps",
    "SchemaPath",
    "TimeDeltaImpl",
    "TimeImpl",
    "Tuple",
    "UUIDImpl",
    "Unspecified",
    "UnspecifiedType",
    "classonlymethod",
    "computed_field",
    "dispatch_overload",
    "empty_set_if_none",
)
