---
name: Documentation
about: Report missing, incomplete, or incorrect documentation
title: "[DOCS]"
labels: documentation
assignees: ''
---

**Issue Type**
- [ ] Existing documentation (e.g. typos, errors, outdated information)
- [ ] Suggest new documentation that is currently missing

**Current Behavior or Documentation Gaps**  
For existing documentation:  
A clear and concise description of what is incorrect, missing, or confusing. Include a link to the specific documentation page, if applicable.

For new documentation suggestions:  
Describe the functionality or topic that is currently undocumented, and explain briefly why it would be helpful to document it.

**Suggested Improvement or New Documentation Content**  
Provide details on how to improve the documentation or what content should be added. If you're suggesting a new topic, explain what sections, examples, or tutorials would be beneficial.

**Steps to Reproduce the Problem (if applicable)**  
If this is related to a documentation bug (such as incorrect code or instructions), please describe the steps to reproduce and fix the issue.

**Relevant Links**  
If this issue relates to existing features, APIs, or other projects, please provide relevant links to help clarify the issue or suggested documentation.

**Additional Context**  
Provide any other context or screenshots that might help explain the documentation issue.

**Confirmation**  
Please confirm the following:
- [ ] I have checked the existing issues and pull requests to ensure this documentation issue hasn't been reported before.
- [ ] I have read the project's documentation and am confident this issue or suggestion is valid.
