import aiofiles
# > Local Imports
from .Any import AnyCodec


class OGGCodec(AnyCodec):
    codec_name: str = "OGG"
    
    # ! Testing
    @staticmethod
    def is_this_codec(path: str) -> bool:
        with open(path, "rb") as file:
            return file.read(4) == b'OggS'
    
    @staticmethod
    async def aio_is_this_codec(path: str) -> bool:
        async with aiofiles.open(path, "rb") as file:
            return await file.read(4) == b'OggS'
