/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.SetOperationQuery;
import com.healthmarketscience.sqlbuilder.SqlContext;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.ValidationException;
import com.healthmarketscience.sqlbuilder.Verifiable;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Constraint;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonTableExpression
extends SqlObject
implements Verifiable<CommonTableExpression> {
    private final CTETable _table;
    private SqlObject _query;

    public CommonTableExpression(String name) {
        this._table = new CTETable(name);
    }

    public Table getTable() {
        return this._table;
    }

    public Column addColumn(String name) {
        CTEColumn col = new CTEColumn(name, this._table);
        this._table._columns.add(col);
        return col;
    }

    public Column findColumn(String name) {
        for (CTEColumn col : this._table._columns) {
            if (!col.getColumnNameSQL().equals(name)) continue;
            return col;
        }
        return null;
    }

    public CommonTableExpression setTableAlias(String alias) {
        this._table._alias = alias;
        return this;
    }

    boolean hasTableAlias() {
        return this._table._alias != null;
    }

    public CommonTableExpression setQuery(Object query) {
        this._query = Converter.toCustomSqlObject(query);
        return this;
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        vContext.addVerifiable(this);
        vContext.collectNestedQuerySchemaObjects(this._query);
    }

    @Override
    public void appendTo(AppendableExt app) throws IOException {
        SqlContext context;
        app.append(this._table);
        if (!this._table._columns.isEmpty()) {
            app.append(" (").append(this._table._columns, ",").append(")");
        }
        SqlContext parentContex = (context = (SqlContext)app.getContext()) != null ? context.getParent() : null;
        app.setContext(parentContex);
        app.append(" AS ").append('(').append(this._query).append(')');
        app.setContext(context);
    }

    @Override
    public final CommonTableExpression validate() throws ValidationException {
        this.doValidate();
        return this;
    }

    @Override
    public void validate(ValidationContext vContext) throws ValidationException {
        if (this._query == null) {
            throw new ValidationException("missing cte query");
        }
        SqlObject query = this._query;
        if (query instanceof SetOperationQuery) {
            query = ((SetOperationQuery)this._query).getFirstQuery();
        }
        if (query instanceof SelectQuery) {
            SelectQuery selectQuery = (SelectQuery)query;
            if (selectQuery.hasAllColumns()) {
                throw new ValidationException("Common table expression queries cannot use '*' syntax");
            }
            int numCTECols = this._table._columns.size();
            if (numCTECols > 0 && numCTECols != selectQuery.getColumns().size()) {
                throw new ValidationException("Mismatched number of columns in common table expression");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CTETable
    implements Table {
        private final String _name;
        private String _alias;
        private final List<CTEColumn> _columns = new ArrayList<CTEColumn>();

        private CTETable(String name) {
            this._name = name;
        }

        @Override
        public String getAlias() {
            return this._alias;
        }

        @Override
        public String getTableNameSQL() {
            return this._name;
        }

        @Override
        public List<? extends Column> getColumns() {
            return this._columns;
        }

        @Override
        public List<? extends Constraint> getConstraints() {
            return Collections.emptyList();
        }

        public String toString() {
            return this.getTableNameSQL();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CTEColumn
    implements Column {
        private final String _name;
        private final CTETable _table;

        private CTEColumn(String name, CTETable table) {
            this._name = name;
            this._table = table;
        }

        @Override
        public CTETable getTable() {
            return this._table;
        }

        @Override
        public String getColumnNameSQL() {
            return this._name;
        }

        @Override
        public String getTypeNameSQL() {
            return null;
        }

        @Override
        public Integer getTypeLength() {
            return null;
        }

        @Override
        public List<?> getTypeQualifiers() {
            return Collections.emptyList();
        }

        @Override
        public List<? extends Constraint> getConstraints() {
            return Collections.emptyList();
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }

        public String toString() {
            return this.getColumnNameSQL();
        }
    }
}

