/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder.dbspec.basic;

import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.Constraint;
import com.healthmarketscience.sqlbuilder.dbspec.RejoinTable;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbCheckConstraint;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbConstraint;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbForeignKeyConstraint;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbObject;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSchema;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbTable
extends DbObject<DbSchema>
implements Table {
    private final String _alias;
    private final List<DbColumn> _columns = new ArrayList<DbColumn>();
    private final List<DbConstraint> _constraints = new ArrayList<DbConstraint>();

    public DbTable(DbSchema parent, String name) {
        this(parent, name, parent.getSpec().getNextAlias());
    }

    public DbTable(DbSchema parent, String name, String alias) {
        super(parent, name);
        this._alias = alias;
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    @Override
    public String getTableNameSQL() {
        return this.getAbsoluteName();
    }

    public List<DbColumn> getColumns() {
        return this._columns;
    }

    public List<DbConstraint> getConstraints() {
        return this._constraints;
    }

    public DbColumn findColumn(String name) {
        return DbTable.findObject(this._columns, name);
    }

    public DbColumn[] findColumns(String ... names) {
        if (names == null) {
            return null;
        }
        DbColumn[] cols = new DbColumn[names.length];
        for (int i = 0; i < names.length; ++i) {
            cols[i] = DbTable.findObject(this._columns, names[i]);
        }
        return cols;
    }

    public DbColumn addColumn(String name) {
        return this.addColumn(name, null, null, null);
    }

    public DbColumn addColumn(String name, String typeName, Integer typeLength) {
        return this.addColumn(name, typeName, typeLength, null);
    }

    public DbColumn addColumn(String name, String typeName, Integer typePrecision, Integer typeScale) {
        DbColumn column = this.getSpec().createColumn(this, name, typeName, typePrecision, typeScale);
        return this.addColumn(column);
    }

    public DbColumn addColumn(String name, int type, Integer typeLength) {
        return this.addColumn(name, type, typeLength, null);
    }

    public DbColumn addColumn(String name, int type, Integer typePrecision, Integer typeScale) {
        return this.addColumn(name, DbColumn.getTypeName(type), typePrecision, typeScale);
    }

    public <T extends DbColumn> T addColumn(T column) {
        this._columns.add(this.checkOwnership(column));
        return column;
    }

    public DbConstraint unique(String name, String ... colNames) {
        DbConstraint constraint = this.getSpec().createTableConstraint(this, name, Constraint.Type.UNIQUE, colNames);
        return this.addConstraint(constraint);
    }

    public DbConstraint primaryKey(String name, String ... colNames) {
        DbConstraint constraint = this.getSpec().createTableConstraint(this, name, Constraint.Type.PRIMARY_KEY, colNames);
        return this.addConstraint(constraint);
    }

    public DbForeignKeyConstraint foreignKey(String name, String[] colNames, String referencedTableName, String[] referencedColNames) {
        DbTable referencedTable = ((DbSchema)this.getParent()).findTable(referencedTableName);
        return this.foreignKey(name, this.findColumns(colNames), referencedTable, referencedTable.findColumns(referencedColNames));
    }

    public DbForeignKeyConstraint foreignKey(String name, String[] colNames, String referencedSchemaName, String referencedTableName, String[] referencedColNames) {
        DbTable referencedTable = this.getSpec().findSchema(referencedSchemaName).findTable(referencedTableName);
        return this.foreignKey(name, this.findColumns(colNames), referencedTable, referencedTable.findColumns(referencedColNames));
    }

    public DbForeignKeyConstraint foreignKey(String name, DbColumn[] columns, DbTable referencedTable, DbColumn[] refColumns) {
        DbForeignKeyConstraint fkConstraint = this.getSpec().createTableForeignKeyConstraint(this, name, referencedTable, columns, refColumns);
        return this.addConstraint(fkConstraint);
    }

    public DbCheckConstraint checkCondition(String name, Condition condition) {
        DbCheckConstraint constraint = this.getSpec().createTableCheckConstraint(this, name, condition);
        return this.addConstraint(constraint);
    }

    public <T extends DbConstraint> T addConstraint(T constraint) {
        this._constraints.add(this.checkOwnership(constraint));
        return constraint;
    }

    public RejoinTable rejoin(String newAlias) {
        return new RejoinTable(this, newAlias);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.getAlias() + ")";
    }
}

