/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma.benchmark;

import edu.emory.mathcs.jplasma.tdouble.Dplasma;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import org.netlib.lapack.Dgels;
import org.netlib.util.intW;

public class DgelsBenchmark {
    private static void dgelsBenchmarkJPlasma(int n, int n2, int n3, int n4, int n5) {
        ConcurrencyUtils.setNumberOfThreads(n5);
        int n6 = n;
        int n7 = Math.max(n, n2);
        double[] dArray = new double[n * n2];
        double[] dArray2 = new double[n7 * n3];
        double d = 0.0;
        Dplasma.plasma_Init(n, n2, 1);
        for (int i = 0; i < n4 + 2; ++i) {
            int n8;
            int n9;
            for (n9 = 0; n9 < n; ++n9) {
                for (n8 = 0; n8 < n2; ++n8) {
                    dArray[n * n8 + n9] = 0.5 - Math.random();
                }
            }
            for (n9 = 0; n9 < n7; ++n9) {
                for (n8 = 0; n8 < n3; ++n8) {
                    dArray2[n * n8 + n9] = Math.random();
                }
            }
            double[] dArray3 = Dplasma.plasma_Allocate_T(n, n2);
            double d2 = System.nanoTime();
            int n10 = Dplasma.plasma_DGELS(111, n, n2, n3, dArray, 0, n6, dArray3, 0, dArray2, 0, n7);
            d2 = (double)System.nanoTime() - d2;
            if (i >= 2) {
                d += d2;
            }
            if (n10 == 0) continue;
            System.err.println("failure with error " + n10);
        }
        System.out.println("Average execution time of JPlasma DGELS (" + n + "x" + n2 + ", " + n3 + " right-hand sides, " + n5 + " threads): " + d / (double)n4 / 1000000.0 + " milliseconds");
        Dplasma.plasma_Finalize();
    }

    private static void dgelsBenchmarkJLAPACK(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = Math.max(n, n2);
        int n7 = Math.min(n, n2);
        int n8 = Math.max(1, n7 + Math.max(n7, n3));
        double[] dArray = new double[n * n2];
        double[] dArray2 = new double[n6 * n3];
        double d = 0.0;
        Dplasma.plasma_Init(n, n2, 1);
        for (int i = 0; i < n4 + 2; ++i) {
            int n9;
            int n10;
            for (n10 = 0; n10 < n; ++n10) {
                for (n9 = 0; n9 < n2; ++n9) {
                    dArray[n * n9 + n10] = 0.5 - Math.random();
                }
            }
            for (n10 = 0; n10 < n6; ++n10) {
                for (n9 = 0; n9 < n3; ++n9) {
                    dArray2[n * n9 + n10] = Math.random();
                }
            }
            double[] dArray3 = new double[n8];
            intW intW2 = new intW(0);
            double d2 = System.nanoTime();
            Dgels.dgels("N", n, n2, n3, dArray, 0, n5, dArray2, 0, n6, dArray3, 0, n8, intW2);
            d2 = (double)System.nanoTime() - d2;
            if (i >= 2) {
                d += d2;
            }
            if (intW2.val == 0) continue;
            System.err.println("failure with error " + intW2);
        }
        System.out.println("Average execution time of JLAPACK DGELS (" + n + "x" + n2 + ", " + n3 + " right-hand sides): " + d / (double)n4 / 1000000.0 + " milliseconds");
        Dplasma.plasma_Finalize();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 5) {
            System.out.println("Usage: java edu.emory.mathcs.jplasma.benchmark.DgelsBenchmark M N NRHS NITERS NTHREADS");
            System.exit(1);
        }
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        int n4 = Integer.parseInt(stringArray[3]);
        int n5 = Integer.parseInt(stringArray[4]);
        DgelsBenchmark.dgelsBenchmarkJPlasma(n, n2, n3, n4, n5);
        System.exit(0);
    }
}

