/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma.tdouble;

import edu.emory.mathcs.jplasma.Barrier;
import edu.emory.mathcs.jplasma.tdouble.Dallocate;
import edu.emory.mathcs.jplasma.tdouble.Dauxiliary;
import edu.emory.mathcs.jplasma.tdouble.Dcommon;
import edu.emory.mathcs.jplasma.tdouble.DcoreControl;
import edu.emory.mathcs.jplasma.tdouble.Dglobal;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;

class Dinitialize {
    private Dinitialize() {
    }

    protected static int plasma_Init(int n, int n2, int n3) {
        if (Dcommon.plasma_cntrl != null && Dcommon.plasma_cntrl.initialized) {
            Dauxiliary.plasma_warning("plasma_init", "PLASMA re-initialized");
            return -2;
        }
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1024) {
            Dauxiliary.plasma_error("plasma_init", "not supporting so many cores");
            return -7;
        }
        Dcommon.plasma_cntrl = new Dglobal.Dplasma_cntrl(n4);
        Dcommon.plasma_aux = new Dglobal.Dplasma_aux(n4);
        Dcommon.plasma_args = new Dglobal.Plasma_args();
        Dcommon.plasma_cntrl.cores_max = n4;
        Dcommon.plasma_cntrl.cores_num = n4;
        int n5 = Dallocate.plasma_alloc_aux_work_tau();
        if (n5 != 0) {
            Dauxiliary.plasma_error("plasma_init", "plasma_alloc_work_tau() failed");
            return n5;
        }
        int n6 = Dcommon.plasma_cntrl.NB_min;
        int n7 = n % n6 == 0 ? n / n6 : n / n6 + 1;
        int n8 = n2 % n6 == 0 ? n2 / n6 : n2 / n6 + 1;
        int n9 = n3 % n6 == 0 ? n3 / n6 : n3 / n6 + 1;
        int n10 = Math.max(n7, n8) * Math.max(n8, n9);
        do {
            if ((n5 = Dallocate.plasma_alloc_aux_progress(n10)) == 0 || (n10 = n10 / 4 * 3) != 0) continue;
            Dauxiliary.plasma_error("plasma_init", "plasma_alloc_aux_progress() failed");
            return -6;
        } while (n5 != 0);
        n6 = Dcommon.plasma_cntrl.NB_max;
        int n11 = Dcommon.plasma_cntrl.IB_max;
        n7 = n % n6 == 0 ? n / n6 : n / n6 + 1;
        n8 = n2 % n6 == 0 ? n2 / n6 : n2 / n6 + 1;
        n9 = n3 % n6 == 0 ? n3 / n6 : n3 / n6 + 1;
        n10 = (n7 * n8 + n7 * n9) * n6 * n6 + n7 * n8 * n11 * n6;
        do {
            if ((n5 = Dallocate.plasma_alloc_aux_bdl(n10)) == 0 || (n10 = n10 / 4 * 3) != 0) continue;
            Dauxiliary.plasma_error("plasma_init", "plasma_alloc_aux_bld() failed");
            return -6;
        } while (n5 != 0);
        Barrier.plasma_barrier_init(Dcommon.plasma_cntrl.cores_num - 1);
        int n12 = Dcommon.plasma_cntrl.cores_num;
        int[] nArray = Dcommon.plasma_cntrl.core_num;
        Future<?>[] futureArray = Dcommon.plasma_cntrl.workers;
        for (int i = 1; i < n12; ++i) {
            nArray[i] = i;
            futureArray[i] = ConcurrencyUtils.submit(new DcoreControl(i));
        }
        nArray[0] = 0;
        Barrier.plasma_barrier(0, n12);
        Dcommon.plasma_cntrl.initialized = true;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int plasma_Finalize() {
        if (!Dcommon.plasma_cntrl.initialized) {
            Dauxiliary.plasma_warning("plasma_finalize", "PLASMA not initialized");
            return -1;
        }
        Lock lock = Dcommon.plasma_cntrl.action_mutex;
        lock.lock();
        try {
            Dcommon.plasma_cntrl.action = 1;
            Dcommon.plasma_cntrl.action_condt.signalAll();
        }
        finally {
            lock.unlock();
        }
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        int n = Dallocate.plasma_free_aux_bdl();
        if (n != 0) {
            Dauxiliary.plasma_error("plasma_finalize", "plasma_free_aux_bdl() failed");
        }
        if ((n = Dallocate.plasma_free_aux_progress()) != 0) {
            Dauxiliary.plasma_error("plasma_finalize", "plasma_free_aux_progress() failed");
        }
        if ((n = Dallocate.plasma_free_aux_work_tau()) != 0) {
            Dauxiliary.plasma_error("plasma_finalize", "plasma_free_aux_work_tau() failed");
        }
        Dcommon.plasma_cntrl.initialized = false;
        return 0;
    }
}

