/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma.test;

import edu.emory.mathcs.jplasma.tdouble.Dplasma;
import org.netlib.blas.Dgemm;
import org.netlib.blas.Dtrmm;
import org.netlib.lapack.Dlacpy;
import org.netlib.lapack.Dlange;

public class DposvTest {
    public static void main(String[] stringArray) {
        int n = 10;
        for (int i = 0; i < n; ++i) {
            DposvTest.dposvTest(stringArray);
        }
    }

    public static void dposvTest(String[] stringArray) {
        int n;
        int n2;
        if (stringArray.length != 4) {
            System.out.print(" Proper Usage is : java edu.emory.mathcs.jplasma.test.DposvTest N LDA NRHS LDB with \n - N : the size of the matrix \n - LDA : leading dimension of the matrix A \n - NRHS : number of RHS \n - LDB : leading dimension of the RHS B \n");
            System.exit(1);
        }
        int n3 = Integer.parseInt(stringArray[0]);
        int n4 = Integer.parseInt(stringArray[1]);
        int n5 = Integer.parseInt(stringArray[2]);
        int n6 = Integer.parseInt(stringArray[3]);
        double[] dArray = new double[n4 * n3];
        double[] dArray2 = new double[n4 * n3];
        double[] dArray3 = new double[n6 * n5];
        double[] dArray4 = new double[n6 * n5];
        Dplasma.plasma_Init(n3, n3, n5);
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                double d = 0.5 - Math.random();
                dArray2[n4 * n + n2] = d;
                dArray[n4 * n + n2] = d;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n4 * n2 + n2] = dArray[n4 * n2 + n2] + (double)n3;
            dArray2[n4 * n2 + n2] = dArray[n4 * n2 + n2];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                double d = dArray[n4 * n2 + n];
                dArray[n4 * n + n2] = d;
                dArray2[n4 * n + n2] = d;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n5; ++n) {
                double d = 0.5 - Math.random();
                dArray4[n6 * n + n2] = d;
                dArray3[n6 * n + n2] = d;
            }
        }
        Dplasma.plasma_DPOSV(121, n3, n5, dArray2, 0, n4, dArray4, 0, n6);
        Dplasma.plasma_Finalize();
        int n7 = 121;
        double d = 1.0E-10;
        System.out.print("\n");
        System.out.print("------ TESTS FOR PLASMA DPOSV ROUTINE -------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", n3, n3));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", d));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        int n8 = DposvTest.check_factorization(n3, dArray, dArray2, n4, n7, d);
        int n9 = DposvTest.check_solution(n3, n5, dArray, n4, dArray3, dArray4, n6, d);
        if (n9 == 0 & n8 == 0) {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DPOSV ... PASSED !\n");
            System.out.print("************************************************\n");
        } else {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DPOSV ... FAILED !\n");
            System.out.print("************************************************\n");
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                double d2 = 0.5 - Math.random();
                dArray2[n4 * n + n2] = d2;
                dArray[n4 * n + n2] = d2;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n4 * n2 + n2] = dArray[n4 * n2 + n2] + (double)n3;
            dArray2[n4 * n2 + n2] = dArray[n4 * n2 + n2];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                double d3 = dArray[n4 * n2 + n];
                dArray[n4 * n + n2] = d3;
                dArray2[n4 * n + n2] = d3;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n5; ++n) {
                double d4 = 0.5 - Math.random();
                dArray4[n6 * n + n2] = d4;
                dArray3[n6 * n + n2] = d4;
            }
        }
        Dplasma.plasma_Init(n3, n3, n5);
        Dplasma.plasma_DPOTRF(121, n3, dArray2, 0, n4);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(n3, n3, n5);
        Dplasma.plasma_DPOTRS(121, n3, n5, dArray2, 0, n4, dArray4, 0, n6);
        Dplasma.plasma_Finalize();
        n7 = 121;
        System.out.print("\n");
        System.out.print("------ TESTS FOR PLASMA DPOTRF + DPOTRS ROUTINE -------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", n3, n3));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", d));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        n8 = DposvTest.check_factorization(n3, dArray, dArray2, n4, n7, d);
        n9 = DposvTest.check_solution(n3, n5, dArray, n4, dArray3, dArray4, n6, d);
        if (n9 == 0 & n8 == 0) {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DPOTRF + DPOTRS ... PASSED !\n");
            System.out.print("************************************************\n");
        } else {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DPOTRF + DPOTRS ... FAILED !\n");
            System.out.print("************************************************\n");
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                double d5 = 0.5 - Math.random();
                dArray2[n4 * n + n2] = d5;
                dArray[n4 * n + n2] = d5;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n4 * n2 + n2] = dArray[n4 * n2 + n2] + (double)n3;
            dArray2[n4 * n2 + n2] = dArray[n4 * n2 + n2];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                double d6 = dArray[n4 * n2 + n];
                dArray[n4 * n + n2] = d6;
                dArray2[n4 * n + n2] = d6;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n5; ++n) {
                double d7 = 0.5 - Math.random();
                dArray4[n6 * n + n2] = d7;
                dArray3[n6 * n + n2] = d7;
            }
        }
        Dplasma.plasma_Init(n3, n3, n5);
        Dplasma.plasma_DPOTRF(122, n3, dArray2, 0, n4);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(n3, n3, n5);
        Dplasma.plasma_DTRSM(141, 122, 111, 131, n3, n5, dArray2, 0, n4, dArray4, 0, n6);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(n3, n3, n5);
        Dplasma.plasma_DTRSM(141, 122, 112, 131, n3, n5, dArray2, 0, n4, dArray4, 0, n6);
        Dplasma.plasma_Finalize();
        n7 = 122;
        System.out.print("\n");
        System.out.print("------ TESTS FOR PLASMA DPOTRF + DTRSM + DTRSM  ROUTINE -------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", n3, n3));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", d));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        n8 = DposvTest.check_factorization(n3, dArray, dArray2, n4, n7, d);
        n9 = DposvTest.check_solution(n3, n5, dArray, n4, dArray3, dArray4, n6, d);
        if (n9 == 0 & n8 == 0) {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DPOTRF + DTRSM + DTRSM ... PASSED !\n");
            System.out.print("************************************************\n");
        } else {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DPOTRF + DTRSM + DTRSM ... FAILED !\n");
            System.out.print("************************************************\n");
        }
    }

    private static int check_factorization(int n, double[] dArray, double[] dArray2, int n2, int n3, double d) {
        int n4;
        String string = "I";
        double[] dArray3 = new double[n * n];
        double[] dArray4 = new double[n * n];
        double[] dArray5 = new double[n * n];
        double[] dArray6 = new double[n];
        double d2 = 1.0;
        Dlacpy.dlacpy("ALL", n, n, dArray, 0, n2, dArray3, 0, n);
        if (n3 == 121) {
            Dlacpy.dlacpy(Dplasma.lapack_const(121), n, n, dArray2, 0, n2, dArray4, 0, n);
            Dlacpy.dlacpy(Dplasma.lapack_const(121), n, n, dArray2, 0, n2, dArray5, 0, n);
            Dtrmm.dtrmm("L", "U", "T", "N", n, n, d2, dArray4, 0, n, dArray5, 0, n);
        } else {
            Dlacpy.dlacpy(Dplasma.lapack_const(122), n, n, dArray2, 0, n2, dArray4, 0, n);
            Dlacpy.dlacpy(Dplasma.lapack_const(122), n, n, dArray2, 0, n2, dArray5, 0, n);
            Dtrmm.dtrmm("R", "L", "T", "N", n, n, d2, dArray4, 0, n, dArray5, 0, n);
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray3[j * n + i] = dArray5[j * n + i] - dArray3[j * n + i];
            }
        }
        double d3 = Dlange.dlange(string, n, n, dArray3, 0, n, dArray6, 0);
        double d4 = Dlange.dlange(string, n, n, dArray, 0, n2, dArray6, 0);
        System.out.print("============\n");
        System.out.print("Checking the Cholesky Factorization \n");
        System.out.print(String.format("-- ||L'L-A||_oo/(||A||_oo.N.eps) = %e \n", d3 / (d4 * (double)n * d)));
        if (d3 / (d4 * (double)n * d) > 10.0) {
            System.out.print("-- Factorization is suspicious ! \n");
            n4 = 1;
        } else {
            System.out.print("-- Factorization is CORRECT ! \n");
            n4 = 0;
        }
        return n4;
    }

    private static int check_solution(int n, int n2, double[] dArray, int n3, double[] dArray2, double[] dArray3, int n4, double d) {
        int n5;
        String string = "I";
        double[] dArray4 = new double[n];
        double d2 = 1.0;
        double d3 = -1.0;
        double d4 = Dlange.dlange(string, n, n2, dArray3, 0, n4, dArray4, 0);
        double d5 = Dlange.dlange(string, n, n, dArray, 0, n3, dArray4, 0);
        double d6 = Dlange.dlange(string, n, n2, dArray2, 0, n4, dArray4, 0);
        Dgemm.dgemm("N", "N", n, n2, n, d2, dArray, 0, n3, dArray3, 0, n4, d3, dArray2, 0, n4);
        double d7 = Dlange.dlange(string, n, n2, dArray2, 0, n4, dArray4, 0);
        System.out.print("============\n");
        System.out.print("Checking the Residual of the solution \n");
        System.out.print(String.format("-- ||Ax-B||_oo/((||A||_oo||x||_oo+||B||_oo).N.eps) = %e \n", d7 / ((d5 * d4 + d6) * (double)n * d)));
        if (d7 / ((d5 * d4 + d6) * (double)n * d) > 10.0) {
            System.out.print("-- The solution is suspicious ! \n");
            n5 = 1;
        } else {
            System.out.print("-- The solution is CORRECT ! \n");
            n5 = 0;
        }
        return n5;
    }
}

