/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.groundrulestore;

import java.util.Collections;
import java.util.Set;
import org.apache.commons.collections4.SetValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.linqs.psl.application.groundrulestore.MemoryGroundRuleStore;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.Rule;

public class AtomRegisterGroundRuleStore
extends MemoryGroundRuleStore {
    private SetValuedMap<GroundAtom, GroundRule> atomMapping = new HashSetValuedHashMap<GroundAtom, GroundRule>();

    public Set<GroundRule> getRegisteredGroundRules(GroundAtom atom) {
        if (!this.atomMapping.containsKey(atom)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.atomMapping.get(atom));
    }

    @Override
    public synchronized void addGroundRule(GroundRule groundRule) {
        super.addGroundRule(groundRule);
        for (GroundAtom atom : groundRule.getAtoms()) {
            this.atomMapping.put(atom, groundRule);
        }
    }

    @Override
    public void removeGroundRule(GroundRule groundRule) {
        super.removeGroundRule(groundRule);
        for (GroundAtom atom : groundRule.getAtoms()) {
            this.atomMapping.removeMapping(atom, groundRule);
        }
    }

    @Override
    public void removeGroundRules(Rule rule) {
        for (GroundRule groundRule : this.getGroundRules(rule)) {
            for (GroundAtom atom : groundRule.getAtoms()) {
                this.atomMapping.removeMapping(atom, groundRule);
            }
        }
        super.removeGroundRules(rule);
    }

    @Override
    public void close() {
        this.atomMapping.clear();
        this.atomMapping = null;
        super.close();
    }
}

