/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.groundrulestore;

import com.google.common.collect.Iterables;
import org.apache.commons.collections4.SetValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.linqs.psl.application.groundrulestore.GroundRuleStore;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.rule.UnweightedGroundRule;
import org.linqs.psl.model.rule.WeightedGroundRule;

public class MemoryGroundRuleStore
implements GroundRuleStore {
    protected SetValuedMap<Rule, GroundRule> groundRules = new HashSetValuedHashMap<Rule, GroundRule>();

    @Override
    public synchronized void addGroundRule(GroundRule groundRule) {
        this.groundRules.put(groundRule.getRule(), groundRule);
    }

    @Override
    public boolean containsGroundRule(GroundRule groundRule) {
        return this.groundRules.containsMapping(groundRule.getRule(), groundRule);
    }

    @Override
    public Iterable<WeightedGroundRule> getCompatibilityRules() {
        return Iterables.filter(this.groundRules.values(), WeightedGroundRule.class);
    }

    @Override
    public Iterable<UnweightedGroundRule> getConstraintRules() {
        return Iterables.filter(this.groundRules.values(), UnweightedGroundRule.class);
    }

    @Override
    public Iterable<GroundRule> getGroundRules() {
        return this.groundRules.values();
    }

    @Override
    public Iterable<GroundRule> getGroundRules(Rule rule) {
        return this.groundRules.get(rule);
    }

    @Override
    public void removeGroundRule(GroundRule groundRule) {
        this.groundRules.removeMapping(groundRule.getRule(), groundRule);
    }

    @Override
    public void removeGroundRules(Rule rule) {
        this.groundRules.remove(rule);
    }

    @Override
    public int size() {
        return this.groundRules.size();
    }

    @Override
    public int count(Rule rule) {
        return this.groundRules.get(rule).size();
    }

    @Override
    public void close() {
        this.groundRules.clear();
        this.groundRules = null;
    }
}

