/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.inference;

import java.util.List;
import org.linqs.psl.application.ModelApplication;
import org.linqs.psl.application.groundrulestore.GroundRuleStore;
import org.linqs.psl.application.inference.result.FullInferenceResult;
import org.linqs.psl.application.inference.result.memory.MemoryFullInferenceResult;
import org.linqs.psl.application.util.GroundRules;
import org.linqs.psl.application.util.Grounding;
import org.linqs.psl.config.ConfigBundle;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.database.atom.LazyAtomManager;
import org.linqs.psl.model.Model;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.reasoner.Reasoner;
import org.linqs.psl.reasoner.ReasonerFactory;
import org.linqs.psl.reasoner.admm.ADMMReasonerFactory;
import org.linqs.psl.reasoner.term.TermGenerator;
import org.linqs.psl.reasoner.term.TermStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyMPEInference
implements ModelApplication {
    private static final Logger log = LoggerFactory.getLogger(LazyMPEInference.class);
    public static final String CONFIG_PREFIX = "lazympeinference";
    public static final String REASONER_KEY = "lazympeinference.reasoner";
    public static final ReasonerFactory REASONER_DEFAULT = new ADMMReasonerFactory();
    public static final String GROUND_RULE_STORE_KEY = "lazympeinference.groundrulestore";
    public static final String GROUND_RULE_STORE_DEFAULT = "org.linqs.psl.application.groundrulestore.MemoryGroundRuleStore";
    public static final String TERM_STORE_KEY = "lazympeinference.termstore";
    public static final String TERM_STORE_DEFAULT = "org.linqs.psl.reasoner.admm.term.ADMMTermStore";
    public static final String TERM_GENERATOR_KEY = "lazympeinference.termgenerator";
    public static final String TERM_GENERATOR_DEFAULT = "org.linqs.psl.reasoner.admm.term.ADMMTermGenerator";
    public static final String MAX_ROUNDS_KEY = "lazympeinference.maxrounds";
    public static final int MAX_ROUNDS_DEFAULT = 100;
    protected Model model;
    protected Database db;
    protected ConfigBundle config;
    protected final int maxRounds;
    protected Reasoner reasoner;
    protected GroundRuleStore groundRuleStore;
    protected TermStore termStore;
    protected TermGenerator termGenerator;
    protected LazyAtomManager lazyAtomManager;

    public LazyMPEInference(Model model, Database db, ConfigBundle config) {
        this.model = model;
        this.db = db;
        this.config = config;
        this.maxRounds = config.getInt(MAX_ROUNDS_KEY, 100);
        this.initialize();
    }

    private void initialize() {
        try {
            this.reasoner = ((ReasonerFactory)this.config.getFactory(REASONER_KEY, REASONER_DEFAULT)).getReasoner(this.config);
            this.termStore = (TermStore)this.config.getNewObject(TERM_STORE_KEY, TERM_STORE_DEFAULT);
            this.groundRuleStore = (GroundRuleStore)this.config.getNewObject(GROUND_RULE_STORE_KEY, GROUND_RULE_STORE_DEFAULT);
            this.termGenerator = (TermGenerator)this.config.getNewObject(TERM_GENERATOR_KEY, TERM_GENERATOR_DEFAULT);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to prepare storage for inference.", ex);
        }
        this.lazyAtomManager = new LazyAtomManager(this.db, this.config);
        log.debug("Initial grounding.");
        Grounding.groundAll(this.model, (AtomManager)this.lazyAtomManager, this.groundRuleStore);
    }

    public FullInferenceResult mpeInference() {
        LazyMPEInference.inference(this.model.getRules(), this.reasoner, this.groundRuleStore, this.termStore, this.termGenerator, this.lazyAtomManager, this.maxRounds);
        double incompatibility = GroundRules.getTotalWeightedIncompatibility(this.groundRuleStore.getCompatibilityRules());
        double infeasibility = GroundRules.getInfeasibilityNorm(this.groundRuleStore.getConstraintRules());
        return new MemoryFullInferenceResult(incompatibility, infeasibility, this.lazyAtomManager.getPersistedRVAtoms().size(), this.groundRuleStore.size());
    }

    public static void inference(List<Rule> rules, Reasoner reasoner, GroundRuleStore groundRuleStore, TermStore termStore, TermGenerator termGenerator, LazyAtomManager lazyAtomManager, int maxRounds) {
        int rounds = 0;
        int numActivated = 0;
        do {
            log.debug("Starting round {} of inference.", (Object)(++rounds));
            termStore.clear();
            log.debug("Initializing objective terms for {} ground rules.", (Object)groundRuleStore.size());
            int termCount = termGenerator.generateTerms(groundRuleStore, termStore);
            log.debug("Generated {} objective terms from {} ground rules.", (Object)termCount, (Object)groundRuleStore.size());
            log.info("Beginning inference round {}.", (Object)rounds);
            reasoner.optimize(termStore);
            log.info("Inference round {} complete.", (Object)rounds);
            if (rounds < maxRounds) {
                numActivated = lazyAtomManager.activateAtoms(rules, groundRuleStore);
            }
            log.debug("Completed round {} and activated {} atoms.", (Object)rounds, (Object)numActivated);
        } while (numActivated > 0 && rounds < maxRounds);
        lazyAtomManager.commitPersistedAtoms();
    }

    @Override
    public void close() {
        this.termStore.close();
        this.groundRuleStore.close();
        this.reasoner.close();
        this.termStore = null;
        this.groundRuleStore = null;
        this.reasoner = null;
        this.model = null;
        this.db = null;
        this.config = null;
    }

    public Reasoner getReasoner() {
        return this.reasoner;
    }

    public GroundRuleStore getGroundRuleStore() {
        return this.groundRuleStore;
    }

    public TermStore getTermStore() {
        return this.termStore;
    }
}

