/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.inference;

import org.linqs.psl.application.ModelApplication;
import org.linqs.psl.application.groundrulestore.GroundRuleStore;
import org.linqs.psl.application.inference.result.FullInferenceResult;
import org.linqs.psl.application.inference.result.memory.MemoryFullInferenceResult;
import org.linqs.psl.application.util.GroundRules;
import org.linqs.psl.application.util.Grounding;
import org.linqs.psl.config.ConfigBundle;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.database.atom.PersistedAtomManager;
import org.linqs.psl.model.Model;
import org.linqs.psl.reasoner.Reasoner;
import org.linqs.psl.reasoner.term.TermGenerator;
import org.linqs.psl.reasoner.term.TermStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPEInference
implements ModelApplication {
    private static final Logger log = LoggerFactory.getLogger(MPEInference.class);
    public static final String CONFIG_PREFIX = "mpeinference";
    public static final String REASONER_KEY = "mpeinference.reasoner";
    public static final String REASONER_DEFAULT = "org.linqs.psl.reasoner.admm.ADMMReasoner";
    public static final String GROUND_RULE_STORE_KEY = "mpeinference.groundrulestore";
    public static final String GROUND_RULE_STORE_DEFAULT = "org.linqs.psl.application.groundrulestore.MemoryGroundRuleStore";
    public static final String TERM_STORE_KEY = "mpeinference.termstore";
    public static final String TERM_STORE_DEFAULT = "org.linqs.psl.reasoner.admm.term.ADMMTermStore";
    public static final String TERM_GENERATOR_KEY = "mpeinference.termgenerator";
    public static final String TERM_GENERATOR_DEFAULT = "org.linqs.psl.reasoner.admm.term.ADMMTermGenerator";
    protected Model model;
    protected Database db;
    protected ConfigBundle config;
    protected Reasoner reasoner;
    protected PersistedAtomManager atomManager;
    protected GroundRuleStore groundRuleStore;
    protected TermStore termStore;

    public MPEInference(Model model, Database db, ConfigBundle config) {
        this.model = model;
        this.db = db;
        this.config = config;
        this.initialize();
    }

    protected void initialize() {
        TermGenerator termGenerator = null;
        try {
            this.reasoner = (Reasoner)this.config.getNewObject(REASONER_KEY, REASONER_DEFAULT);
            this.termStore = (TermStore)this.config.getNewObject(TERM_STORE_KEY, TERM_STORE_DEFAULT);
            this.groundRuleStore = (GroundRuleStore)this.config.getNewObject(GROUND_RULE_STORE_KEY, GROUND_RULE_STORE_DEFAULT);
            termGenerator = (TermGenerator)this.config.getNewObject(TERM_GENERATOR_KEY, TERM_GENERATOR_DEFAULT);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to prepare storage for inference.", ex);
        }
        log.debug("Creating persisted atom mannager.");
        this.atomManager = new PersistedAtomManager(this.db);
        log.info("Grounding out model.");
        int groundCount = Grounding.groundAll(this.model, (AtomManager)this.atomManager, this.groundRuleStore);
        log.debug("Initializing objective terms for {} ground rules.", (Object)groundCount);
        int termCount = termGenerator.generateTerms(this.groundRuleStore, this.termStore);
        log.debug("Generated {} objective terms from {} ground rules.", (Object)termCount, (Object)groundCount);
    }

    public FullInferenceResult mpeInference() {
        log.info("Beginning inference.");
        this.reasoner.optimize(this.termStore);
        log.info("Inference complete. Writing results to Database.");
        this.atomManager.commitPersistedAtoms();
        log.info("Results committed to database.");
        double incompatibility = GroundRules.getTotalWeightedIncompatibility(this.groundRuleStore.getCompatibilityRules());
        double infeasibility = GroundRules.getInfeasibilityNorm(this.groundRuleStore.getConstraintRules());
        return new MemoryFullInferenceResult(incompatibility, infeasibility, this.atomManager.getPersistedRVAtoms().size(), this.groundRuleStore.size());
    }

    public Reasoner getReasoner() {
        return this.reasoner;
    }

    public GroundRuleStore getGroundRuleStore() {
        return this.groundRuleStore;
    }

    public TermStore getTermStore() {
        return this.termStore;
    }

    @Override
    public void close() {
        this.termStore.close();
        this.groundRuleStore.close();
        this.reasoner.close();
        this.termStore = null;
        this.groundRuleStore = null;
        this.reasoner = null;
        this.model = null;
        this.db = null;
        this.config = null;
    }
}

