/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.learning.weight;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.atom.PersistedAtomManager;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.ObservedAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;

public class TrainingMap {
    private final Map<RandomVariableAtom, ObservedAtom> trainingMap = new HashMap<RandomVariableAtom, ObservedAtom>();
    private final Set<RandomVariableAtom> latentVariables = new HashSet<RandomVariableAtom>();

    public TrainingMap(PersistedAtomManager rvAtomManager, Database observedDB) {
        for (RandomVariableAtom rvAtom : rvAtomManager.getPersistedRVAtoms()) {
            GroundAtom otherAtom = observedDB.getAtom(rvAtom.getPredicate(), rvAtom.getArguments());
            if (otherAtom instanceof ObservedAtom) {
                this.trainingMap.put(rvAtom, (ObservedAtom)otherAtom);
                continue;
            }
            this.latentVariables.add(rvAtom);
        }
    }

    public Map<RandomVariableAtom, ObservedAtom> getTrainingMap() {
        return Collections.unmodifiableMap(this.trainingMap);
    }

    public Set<RandomVariableAtom> getLatentVariables() {
        return Collections.unmodifiableSet(this.latentVariables);
    }
}

