/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.learning.weight.search;

import java.util.List;
import java.util.Random;
import org.linqs.psl.application.learning.weight.search.GridSearch;
import org.linqs.psl.config.ConfigBundle;
import org.linqs.psl.database.Database;
import org.linqs.psl.model.Model;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.util.StringUtils;

public class RandomGridSearch
extends GridSearch {
    public static final String CONFIG_PREFIX = "randomgridsearch";
    public static final String MAX_LOCATIONS_KEY = "randomgridsearch.maxlocations";
    public static final int MAX_LOCATIONS_DEFAULT = 150;
    public static final String SEED_KEY = "randomgridsearch.seed";
    public static final long SEED_DEFAULT = 4L;
    private Random rand;

    public RandomGridSearch(Model model, Database rvDB, Database observedDB, ConfigBundle config) {
        this(model.getRules(), rvDB, observedDB, config);
    }

    public RandomGridSearch(List<Rule> rules, Database rvDB, Database observedDB, ConfigBundle config) {
        super(rules, rvDB, observedDB, config);
        int maxLocations = config.getInt(MAX_LOCATIONS_KEY, 150);
        if (maxLocations < 1) {
            throw new IllegalArgumentException("Need at least one location for grid search.");
        }
        this.numLocations = Math.min(this.numLocations, maxLocations);
        long seed = config.getLong(SEED_KEY, 4L);
        this.rand = new Random(seed);
    }

    @Override
    protected boolean chooseNextLocation() {
        do {
            this.currentLocation = this.randomConfiguration();
        } while (this.objectives.containsKey(this.currentLocation));
        return true;
    }

    protected String randomConfiguration() {
        int[] indexes = new int[this.mutableRules.size()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = this.rand.nextInt(this.possibleWeights.length);
        }
        return StringUtils.join(indexes, ":");
    }
}

