/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.cli;

import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.database.DataStore;
import org.linqs.psl.database.Partition;
import org.linqs.psl.database.loading.Inserter;
import org.linqs.psl.model.predicate.PredicateFactory;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.term.ConstantType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class DataLoader {
    private static final Logger log = LoggerFactory.getLogger(DataLoader.class);

    private static Set<StandardPredicate> definePredicates(DataStore datastore, Map yamlMap, boolean useIntIds) {
        if (!yamlMap.containsKey("predicates")) {
            throw new IllegalArgumentException("No 'predicates' block defined in data specification");
        }
        HashSet<StandardPredicate> closed = new HashSet<StandardPredicate>();
        PredicateFactory predicateFactory = PredicateFactory.getFactory();
        for (Map.Entry predicateSpec : ((Map)yamlMap.get("predicates")).entrySet()) {
            String[] predicateParts = ((String)predicateSpec.getKey()).split("/", 2);
            if (predicateParts.length < 2) {
                throw new IllegalArgumentException("Improperly specified predicate " + (String)predicateSpec.getKey());
            }
            String predicateStr = predicateParts[0];
            int arity = Integer.parseInt(predicateParts[1]);
            log.debug("Found predicate {} with arity {}", (Object)predicateStr, (Object)arity);
            ConstantType[] args = new ConstantType[arity];
            for (int i = 0; i < arity; ++i) {
                args[i] = useIntIds ? ConstantType.UniqueIntID : ConstantType.UniqueStringID;
            }
            StandardPredicate predicate = predicateFactory.createStandardPredicate(predicateStr, args);
            datastore.registerPredicate(predicate);
            if (!((String)predicateSpec.getValue()).equalsIgnoreCase("closed")) continue;
            closed.add(predicate);
        }
        return closed;
    }

    private static void loadDataFiles(DataStore datastore, Map yamlMap) {
        for (String partitionName : yamlMap.keySet()) {
            if (partitionName.equalsIgnoreCase("predicates") || partitionName.equalsIgnoreCase("PredicateDetails")) continue;
            PredicateFactory predicateFactory = PredicateFactory.getFactory();
            Partition partition = datastore.getPartition(partitionName);
            for (Map.Entry loadSpec : ((Map)yamlMap.get(partitionName)).entrySet()) {
                log.debug("Loading data for {} ({} partition)", loadSpec.getKey(), (Object)partitionName);
                StandardPredicate predicate = (StandardPredicate)predicateFactory.getPredicate((String)loadSpec.getKey());
                Inserter insert = datastore.getInserter(predicate, partition);
                if (loadSpec.getValue() instanceof String) {
                    insert.loadDelimitedDataAutomatic((String)loadSpec.getValue());
                    continue;
                }
                if (loadSpec.getValue() instanceof List) {
                    for (String filename : (List)loadSpec.getValue()) {
                        insert.loadDelimitedDataAutomatic(filename);
                    }
                    continue;
                }
                throw new IllegalArgumentException("Unknown specification when loading " + partitionName);
            }
        }
    }

    public static Set<StandardPredicate> load(DataStore datastore, InputStream inputStream, boolean useIntIds) {
        Yaml yaml = new Yaml();
        Map yamlParse = (Map)yaml.load(inputStream);
        Set<StandardPredicate> closedPredicates = DataLoader.definePredicates(datastore, yamlParse, useIntIds);
        DataLoader.loadDataFiles(datastore, yamlParse);
        return closedPredicates;
    }
}

