/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.config;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.DataConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.OptionConverter;
import org.linqs.psl.config.ConfigBundle;
import org.linqs.psl.config.Factory;
import org.linqs.psl.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager {
    private static final Logger log = LoggerFactory.getLogger(ConfigManager.class);
    private static ConfigManager instance = null;
    private DataConfiguration masterConfig = new DataConfiguration(new BaseConfiguration());

    private ConfigManager() throws ConfigurationException {
        String pslConfigFile = OptionConverter.getSystemProperty("psl.configuration", "psl.properties");
        if (new File(pslConfigFile).isFile()) {
            this.loadResource(pslConfigFile);
        } else {
            URL resourceURL = Loader.getResource(pslConfigFile);
            if (resourceURL != null) {
                this.loadResource(resourceURL);
            } else {
                log.debug("PSL configuration {} file not found. Only default values will be used unless additional properties are specified.", (Object)pslConfigFile);
            }
        }
    }

    public static ConfigManager getManager() throws ConfigurationException {
        if (instance == null) {
            instance = new ConfigManager();
        }
        return instance;
    }

    public void loadResource(String path) throws ConfigurationException {
        this.masterConfig.append(new PropertiesConfiguration(path));
        log.debug("Configuration file loaded: {}", (Object)path);
    }

    public void loadResource(URL url) throws ConfigurationException {
        this.masterConfig.append(new PropertiesConfiguration(url));
        log.debug("Configuration URL loaded: {}", (Object)url);
    }

    public ConfigBundle getBundle(String id) {
        return new ManagedBundle((SubsetConfiguration)this.masterConfig.subset(id));
    }

    private class ManagedBundle
    implements ConfigBundle {
        private DataConfiguration config;
        private String prefix;

        private ManagedBundle(SubsetConfiguration bundleConfig) {
            this.prefix = bundleConfig.getPrefix();
            this.config = new DataConfiguration(new BaseConfiguration());
            this.config.copy(bundleConfig);
        }

        private void logAccess(String key, Object defaultValue) {
            String scopedKey = this.prefix + "." + key;
            if (this.config.containsKey(key)) {
                Object value = this.config.getProperty(key);
                log.debug("Found value {} for option {}.", value, (Object)scopedKey);
            } else {
                log.debug("No value found for option {}. Returning default of {}.", (Object)scopedKey, defaultValue);
            }
        }

        @Override
        public void addProperty(String key, Object value) {
            this.config.addProperty(key, value);
            log.debug("Added {} to option {}.", value, (Object)(this.prefix + "." + key));
        }

        @Override
        public void setProperty(String key, Object value) {
            this.config.setProperty(key, value);
            log.debug("Set option {} to {}.", (Object)(this.prefix + "." + key), value);
        }

        @Override
        public void clearProperty(String key) {
            this.config.clearProperty(key);
            log.debug("Cleared option {}.", (Object)(this.prefix + "." + key));
        }

        @Override
        public void clear() {
            this.config.clear();
            log.debug("Cleared all options in {} bundle.", (Object)this.prefix);
        }

        @Override
        public Object getProperty(String key) {
            this.logAccess(key, "");
            if (this.config.containsKey(key)) {
                return this.config.getProperty(key);
            }
            return null;
        }

        @Override
        public Boolean getBoolean(String key, Boolean defaultValue) {
            this.logAccess(key, defaultValue);
            return this.config.getBoolean(key, defaultValue);
        }

        @Override
        public Double getDouble(String key, Double defaultValue) {
            this.logAccess(key, defaultValue);
            return this.config.getDouble(key, defaultValue);
        }

        @Override
        public String getString(String key, String defaultValue) {
            this.logAccess(key, defaultValue);
            return this.config.getString(key, defaultValue);
        }

        @Override
        public ConfigBundle subset(String prefix) {
            return new ManagedBundle((SubsetConfiguration)this.config.subset(prefix));
        }

        @Override
        public boolean getBoolean(String key, boolean defaultValue) {
            this.logAccess(key, defaultValue);
            return this.config.getBoolean(key, defaultValue);
        }

        @Override
        public byte getByte(String key, byte defaultValue) {
            this.logAccess(key, defaultValue);
            return this.config.getByte(key, defaultValue);
        }

        @Override
        public Byte getByte(String key, Byte defaultValue) {
            this.logAccess(key, defaultValue);
            return this.config.getByte(key, defaultValue);
        }

        @Override
        public double getDouble(String key, double defaultValue) {
            this.logAccess(key, defaultValue);
            return this.config.getDouble(key, defaultValue);
        }

        @Override
        public float getFloat(String key, float defaultValue) {
            this.logAccess(key, Float.valueOf(defaultValue));
            return this.config.getFloat(key, defaultValue);
        }

        @Override
        public Float getFloat(String key, Float defaultValue) {
            this.logAccess(key, defaultValue);
            return this.config.getFloat(key, defaultValue);
        }

        @Override
        public int getInt(String key, int defaultValue) {
            this.logAccess(key, defaultValue);
            return this.config.getInt(key, defaultValue);
        }

        @Override
        public Integer getInteger(String key, Integer defaultValue) {
            this.logAccess(key, defaultValue);
            return this.config.getInteger(key, defaultValue);
        }

        @Override
        public long getLong(String key, long defaultValue) {
            this.logAccess(key, defaultValue);
            return this.config.getLong(key, defaultValue);
        }

        @Override
        public Long getLong(String key, Long defaultValue) {
            this.logAccess(key, defaultValue);
            return this.config.getLong(key, defaultValue);
        }

        @Override
        public short getShort(String key, short defaultValue) {
            this.logAccess(key, defaultValue);
            return this.config.getShort(key, defaultValue);
        }

        @Override
        public Short getShort(String key, Short defaultValue) {
            this.logAccess(key, defaultValue);
            return this.config.getShort(key, defaultValue);
        }

        @Override
        public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
            this.logAccess(key, defaultValue);
            return this.config.getBigDecimal(key, defaultValue);
        }

        @Override
        public BigInteger getBigInteger(String key, BigInteger defaultValue) {
            this.logAccess(key, defaultValue);
            return this.config.getBigInteger(key, defaultValue);
        }

        @Override
        public List<String> getList(String key, List<String> defaultValue) {
            this.logAccess(key, defaultValue);
            List configList = this.config.getList(key, defaultValue);
            ArrayList<String> toReturn = new ArrayList<String>(configList.size());
            for (int i = 0; i < configList.size(); ++i) {
                toReturn.add((String)configList.get(i));
            }
            return toReturn;
        }

        @Override
        public Factory getFactory(String key, Factory defaultValue) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            this.logAccess(key, defaultValue);
            Object value = this.config.getProperty(key);
            if (value == null) {
                return defaultValue;
            }
            if (value instanceof Factory) {
                return (Factory)value;
            }
            if (value instanceof String) {
                return (Factory)ClassLoader.getSystemClassLoader().loadClass((String)value).newInstance();
            }
            throw new IllegalArgumentException("Value " + value + " is not a Factory nor a String.");
        }

        @Override
        public Enum<?> getEnum(String key, Enum<?> defaultValue) {
            this.logAccess(key, defaultValue);
            return (Enum)this.config.get(defaultValue.getDeclaringClass(), key, defaultValue);
        }

        @Override
        public Object getNewObject(String key, String defaultValue) {
            this.logAccess(key, defaultValue);
            String className = this.config.getString(key, defaultValue);
            if (className == null) {
                return null;
            }
            return Objects.newObject(className, (ConfigBundle)this);
        }

        public String toString() {
            StringBuilder string = new StringBuilder();
            Iterator itr = this.config.getKeys();
            while (itr.hasNext()) {
                String key = (String)itr.next();
                string.append(this.prefix + "." + key + ": " + this.config.getProperty(key) + "\n");
            }
            return string.toString();
        }
    }
}

