/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database;

import java.util.List;
import java.util.Set;
import org.linqs.psl.database.DataStore;
import org.linqs.psl.database.DatabaseQuery;
import org.linqs.psl.database.ResultList;
import org.linqs.psl.model.atom.AtomCache;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.ObservedAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.term.Constant;

public interface Database {
    public GroundAtom getAtom(Predicate var1, Constant ... var2);

    public boolean hasAtom(StandardPredicate var1, Constant ... var2);

    public int countAllGroundAtoms(StandardPredicate var1);

    public int countAllGroundRandomVariableAtoms(StandardPredicate var1);

    public List<GroundAtom> getAllGroundAtoms(StandardPredicate var1);

    public List<RandomVariableAtom> getAllGroundRandomVariableAtoms(StandardPredicate var1);

    public List<ObservedAtom> getAllGroundObservedAtoms(StandardPredicate var1);

    public boolean deleteAtom(GroundAtom var1);

    public void commit(RandomVariableAtom var1);

    public void commit(Iterable<RandomVariableAtom> var1);

    public void commit(Iterable<RandomVariableAtom> var1, int var2);

    public void moveToWritePartition(StandardPredicate var1, int var2);

    public ResultList executeQuery(DatabaseQuery var1);

    public ResultList executeGroundingQuery(Formula var1);

    public boolean isClosed(StandardPredicate var1);

    public Set<StandardPredicate> getRegisteredPredicates();

    public DataStore getDataStore();

    public AtomCache getAtomCache();

    public void close();
}

