/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.Queries;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.QueryAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.Term;
import org.linqs.psl.model.term.Variable;

public class DatabasePopulator {
    private final Database db;
    private Map<Variable, Set<Constant>> substitutions;
    private Predicate rootPredicate;
    private Term[] rootArguments;

    public DatabasePopulator(Database db) {
        this.db = db;
    }

    public void populate(QueryAtom qAtom, Map<Variable, Set<Constant>> substitutions) {
        this.substitutions = substitutions;
        this.rootPredicate = qAtom.getPredicate();
        this.rootArguments = qAtom.getArguments();
        Constant[] groundArguments = new Constant[this.rootArguments.length];
        this.groundAndPersistAtom(0, groundArguments);
    }

    public void populateFromDB(Database sourceDB, StandardPredicate p) {
        for (GroundAtom ga : Queries.getAllAtoms(sourceDB, p)) {
            Constant[] arguments = ga.getArguments();
            GroundAtom rv = this.db.getAtom(p, arguments);
            if (!(rv instanceof RandomVariableAtom)) continue;
            this.db.commit((RandomVariableAtom)rv);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void groundAndPersistAtom(int index, Constant[] arguments) {
        if (index < this.rootArguments.length) {
            if (this.rootArguments[index] instanceof Variable) {
                Set<Constant> groundTerms = this.substitutions.get((Variable)this.rootArguments[index]);
                if (groundTerms == null || groundTerms.size() == 0) {
                    throw new RuntimeException("No valid GroundTerm substitutions for " + this.rootArguments[index].toString());
                }
                Iterator<Constant> i$ = groundTerms.iterator();
                while (i$.hasNext()) {
                    Constant term;
                    arguments[index] = term = i$.next();
                    this.groundAndPersistAtom(index + 1, arguments);
                }
                return;
            } else {
                if (!(this.rootArguments[index] instanceof Constant)) throw new RuntimeException("Unknown argument type: " + this.rootArguments[index].getClass().getName());
                arguments[index] = (Constant)this.rootArguments[index];
                this.groundAndPersistAtom(index + 1, arguments);
            }
            return;
        } else {
            GroundAtom atom = this.db.getAtom(this.rootPredicate, arguments);
            if (!(atom instanceof RandomVariableAtom)) return;
            this.db.commit((RandomVariableAtom)atom);
        }
    }
}

