/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database;

import java.util.List;
import org.joda.time.DateTime;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.DatabaseQuery;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.QueryAtom;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.ConstantType;
import org.linqs.psl.model.term.DateAttribute;
import org.linqs.psl.model.term.DoubleAttribute;
import org.linqs.psl.model.term.IntegerAttribute;
import org.linqs.psl.model.term.LongAttribute;
import org.linqs.psl.model.term.StringAttribute;
import org.linqs.psl.model.term.Term;
import org.linqs.psl.model.term.UniqueIntID;
import org.linqs.psl.model.term.UniqueStringID;
import org.linqs.psl.model.term.Variable;

public class Queries {
    public static int countAllGroundAtoms(Database db, StandardPredicate predicate) {
        return db.countAllGroundAtoms(predicate);
    }

    public static int countAllGroundRandomVariableAtoms(Database db, StandardPredicate predicate) {
        return db.countAllGroundRandomVariableAtoms(predicate);
    }

    public static List<GroundAtom> getAllAtoms(Database db, StandardPredicate predicate) {
        return db.getAllGroundAtoms(predicate);
    }

    public static DatabaseQuery getQueryForAllAtoms(StandardPredicate predicate) {
        Term[] args = new Variable[predicate.getArity()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = new Variable("Vars" + i);
        }
        return new DatabaseQuery(new QueryAtom(predicate, args));
    }

    public static QueryAtom getQueryAtom(StandardPredicate predicate, Object ... rawArgs) {
        return new QueryAtom(predicate, Queries.convertArguments(predicate, rawArgs));
    }

    public static Term[] convertArguments(StandardPredicate predicate, Object ... rawArgs) {
        assert (predicate.getArity() == rawArgs.length);
        Term[] args = new Term[rawArgs.length];
        block11: for (int i = 0; i < rawArgs.length; ++i) {
            ConstantType type = predicate.getArgumentType(i);
            if (rawArgs[i] instanceof Variable) {
                args[i] = (Variable)rawArgs[i];
                continue;
            }
            if (rawArgs[i] instanceof Constant && type.isInstance((Constant)rawArgs[i])) {
                args[i] = (Constant)rawArgs[i];
                continue;
            }
            switch (type) {
                case UniqueIntID: {
                    if (!(rawArgs[i] instanceof Integer)) {
                        throw new IllegalArgumentException("UniqueIntID must be an Integer.");
                    }
                    args[i] = new UniqueIntID((Integer)rawArgs[i]);
                    continue block11;
                }
                case UniqueStringID: {
                    if (!(rawArgs[i] instanceof String)) {
                        throw new IllegalArgumentException("UniqueStringID must be a String.");
                    }
                    args[i] = new UniqueStringID((String)rawArgs[i]);
                    continue block11;
                }
                case String: {
                    args[i] = new StringAttribute(rawArgs[i].toString());
                    continue block11;
                }
                case Double: {
                    if (rawArgs[i] instanceof Double) {
                        args[i] = new DoubleAttribute((Double)rawArgs[i]);
                        continue block11;
                    }
                    if (rawArgs[i] instanceof String) {
                        args[i] = new DoubleAttribute(Double.parseDouble((String)rawArgs[i]));
                        continue block11;
                    }
                    throw new IllegalArgumentException("Could not convert raw arg " + i + " to Double.");
                }
                case Integer: {
                    if (rawArgs[i] instanceof Integer) {
                        args[i] = new IntegerAttribute((Integer)rawArgs[i]);
                        continue block11;
                    }
                    if (rawArgs[i] instanceof String) {
                        args[i] = new IntegerAttribute(Integer.parseInt((String)rawArgs[i]));
                        continue block11;
                    }
                    throw new IllegalArgumentException("Could not convert raw arg " + i + " to Integer.");
                }
                case Long: {
                    if (rawArgs[i] instanceof Long) {
                        args[i] = new LongAttribute((Long)rawArgs[i]);
                        continue block11;
                    }
                    throw new IllegalArgumentException("Could not convert raw arg " + i + " to Long.");
                }
                case Date: {
                    try {
                        args[i] = new DateAttribute(new DateTime(rawArgs[i]));
                        continue block11;
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Could not convert raw arg " + i + " to Date.");
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized argument type " + (Object)((Object)type) + " at index " + i + ".");
                }
            }
        }
        return args;
    }
}

