/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database;

import java.util.HashSet;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.DatabaseQuery;
import org.linqs.psl.database.ResultList;
import org.linqs.psl.model.atom.Atom;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.predicate.ExternalFunctionalPredicate;
import org.linqs.psl.model.predicate.FunctionalPredicate;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.SpecialPredicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.term.Constant;

public class ReadOnlyDatabase {
    private final Database db;

    public ReadOnlyDatabase(Database db) {
        this.db = db;
    }

    public GroundAtom getAtom(Predicate predicate, Constant ... arguments) {
        if (predicate instanceof ExternalFunctionalPredicate) {
            return this.db.getAtom(predicate, arguments);
        }
        if (predicate instanceof StandardPredicate) {
            if (this.db.isClosed((StandardPredicate)predicate)) {
                return this.db.getAtom(predicate, arguments);
            }
            throw new IllegalArgumentException("Can only call getAtom() on a closed or functional predicate.");
        }
        if (predicate instanceof SpecialPredicate) {
            throw new IllegalArgumentException("SpecialPredicates do not have tangible atoms.");
        }
        throw new IllegalArgumentException("Unknown predicate type: " + predicate.getClass().getName());
    }

    public ResultList executeQuery(DatabaseQuery query) {
        HashSet<Atom> atoms = new HashSet<Atom>();
        for (Atom atom : query.getFormula().getAtoms(atoms)) {
            Predicate predicate = atom.getPredicate();
            if (predicate instanceof FunctionalPredicate) continue;
            if (predicate instanceof StandardPredicate) {
                if (this.db.isClosed((StandardPredicate)predicate)) continue;
                throw new IllegalArgumentException("Can only perform queries over closed or functional predicates.");
            }
            if (predicate instanceof SpecialPredicate) {
                throw new IllegalArgumentException("SpecialPredicates do not have tangible atoms.");
            }
            throw new IllegalArgumentException("Unknown predicate type: " + predicate.getClass().getName());
        }
        return this.db.executeQuery(query);
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof ReadOnlyDatabase) {
            return this.db.equals(((ReadOnlyDatabase)other).db);
        }
        return false;
    }

    public int hashCode() {
        return this.db.hashCode();
    }
}

